/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.S3DataSource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3DataSourceMarshaller {
    private static final MarshallingInfo<String> S3DATATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DataType").isBinary(false).build();
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").isBinary(false).build();
    private static final MarshallingInfo<String> S3DATADISTRIBUTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DataDistributionType").isBinary(false).build();
    private static final S3DataSourceMarshaller INSTANCE = new S3DataSourceMarshaller();

    private S3DataSourceMarshaller() {
    }

    public static S3DataSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3DataSource s3DataSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3DataSource, (String)"s3DataSource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3DataSource.s3DataTypeString(), S3DATATYPE_BINDING);
            protocolMarshaller.marshall((Object)s3DataSource.s3Uri(), S3URI_BINDING);
            protocolMarshaller.marshall((Object)s3DataSource.s3DataDistributionTypeString(), S3DATADISTRIBUTIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

