/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;

public class ListEndpointsIterable
implements SdkIterable<ListEndpointsResponse> {
    private final SageMakerClient client;
    private final ListEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEndpointsIterable(SageMakerClient client, ListEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEndpointsResponseFetcher();
    }

    public Iterator<ListEndpointsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListEndpointsIterable resume(ListEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEndpointsIterable(this.client, (ListEndpointsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEndpointsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListEndpointsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListEndpointsResponseFetcher
    implements SyncPageFetcher<ListEndpointsResponse> {
        private ListEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListEndpointsResponse nextPage(ListEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointsIterable.this.client.listEndpoints(ListEndpointsIterable.this.firstRequest);
            }
            return ListEndpointsIterable.this.client.listEndpoints((ListEndpointsRequest)((Object)ListEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

