/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteEndpointRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DeleteEndpointRequest> {
    private final String endpointName;

    private DeleteEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
    }

    public String endpointName() {
        return this.endpointName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEndpointRequest)) {
            return false;
        }
        DeleteEndpointRequest other = (DeleteEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteEndpointRequest").add("EndpointName", (Object)this.endpointName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.of(clazz.cast(this.endpointName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String endpointName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEndpointRequest model) {
            this.endpointName(model.endpointName);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteEndpointRequest build() {
            return new DeleteEndpointRequest(this);
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    CopyableBuilder<Builder, DeleteEndpointRequest> {
        public Builder endpointName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

