/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobSummary;

@SdkInternalApi
public class TrainingJobSummaryMarshaller {
    private static final MarshallingInfo<String> TRAININGJOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobName").build();
    private static final MarshallingInfo<String> TRAININGJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobArn").build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final MarshallingInfo<Instant> TRAININGENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingEndTime").build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").build();
    private static final MarshallingInfo<String> TRAININGJOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobStatus").build();
    private static final TrainingJobSummaryMarshaller INSTANCE = new TrainingJobSummaryMarshaller();

    public static TrainingJobSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TrainingJobSummary trainingJobSummary, ProtocolMarshaller protocolMarshaller) {
        if (trainingJobSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)trainingJobSummary.trainingJobName(), TRAININGJOBNAME_BINDING);
            protocolMarshaller.marshall((Object)trainingJobSummary.trainingJobArn(), TRAININGJOBARN_BINDING);
            protocolMarshaller.marshall((Object)trainingJobSummary.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)trainingJobSummary.trainingEndTime(), TRAININGENDTIME_BINDING);
            protocolMarshaller.marshall((Object)trainingJobSummary.lastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)trainingJobSummary.trainingJobStatusString(), TRAININGJOBSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

