/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummary;

@SdkInternalApi
public class EndpointConfigSummaryMarshaller {
    private static final MarshallingInfo<String> ENDPOINTCONFIGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointConfigName").build();
    private static final MarshallingInfo<String> ENDPOINTCONFIGARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointConfigArn").build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final EndpointConfigSummaryMarshaller INSTANCE = new EndpointConfigSummaryMarshaller();

    public static EndpointConfigSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointConfigSummary endpointConfigSummary, ProtocolMarshaller protocolMarshaller) {
        if (endpointConfigSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)endpointConfigSummary.endpointConfigName(), ENDPOINTCONFIGNAME_BINDING);
            protocolMarshaller.marshall((Object)endpointConfigSummary.endpointConfigArn(), ENDPOINTCONFIGARN_BINDING);
            protocolMarshaller.marshall((Object)endpointConfigSummary.creationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

