/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;

public final class ListEndpointsPaginator
implements SdkIterable<ListEndpointsResponse> {
    private final SageMakerClient client;
    private final ListEndpointsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListEndpointsPaginator(SageMakerClient client, ListEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEndpointsResponseFetcher();
    }

    public Iterator<ListEndpointsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListEndpointsResponseFetcher
    implements NextPageFetcher<ListEndpointsResponse> {
        private ListEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListEndpointsResponse nextPage(ListEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointsPaginator.this.client.listEndpoints(ListEndpointsPaginator.this.firstRequest);
            }
            return ListEndpointsPaginator.this.client.listEndpoints((ListEndpointsRequest)((Object)ListEndpointsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

