/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEndpointConfigResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeEndpointConfigResponse> {
    private final String endpointConfigName;
    private final String endpointConfigArn;
    private final List<ProductionVariant> productionVariants;
    private final Instant creationTime;

    private DescribeEndpointConfigResponse(BuilderImpl builder) {
        super(builder);
        this.endpointConfigName = builder.endpointConfigName;
        this.endpointConfigArn = builder.endpointConfigArn;
        this.productionVariants = builder.productionVariants;
        this.creationTime = builder.creationTime;
    }

    public String endpointConfigName() {
        return this.endpointConfigName;
    }

    public String endpointConfigArn() {
        return this.endpointConfigArn;
    }

    public List<ProductionVariant> productionVariants() {
        return this.productionVariants;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.productionVariants());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointConfigResponse)) {
            return false;
        }
        DescribeEndpointConfigResponse other = (DescribeEndpointConfigResponse)((Object)obj);
        return Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && Objects.equals(this.endpointConfigArn(), other.endpointConfigArn()) && Objects.equals(this.productionVariants(), other.productionVariants()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEndpointConfigResponse").add("EndpointConfigName", (Object)this.endpointConfigName()).add("EndpointConfigArn", (Object)this.endpointConfigArn()).add("ProductionVariants", this.productionVariants()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfigName": {
                return Optional.of(clazz.cast(this.endpointConfigName()));
            }
            case "EndpointConfigArn": {
                return Optional.of(clazz.cast(this.endpointConfigArn()));
            }
            case "ProductionVariants": {
                return Optional.of(clazz.cast(this.productionVariants()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String endpointConfigName;
        private String endpointConfigArn;
        private List<ProductionVariant> productionVariants;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointConfigResponse model) {
            this.endpointConfigName(model.endpointConfigName);
            this.endpointConfigArn(model.endpointConfigArn);
            this.productionVariants(model.productionVariants);
            this.creationTime(model.creationTime);
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        public final String getEndpointConfigArn() {
            return this.endpointConfigArn;
        }

        @Override
        public final Builder endpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
            return this;
        }

        public final void setEndpointConfigArn(String endpointConfigArn) {
            this.endpointConfigArn = endpointConfigArn;
        }

        public final Collection<ProductionVariant.Builder> getProductionVariants() {
            return this.productionVariants != null ? (Collection)this.productionVariants.stream().map(ProductionVariant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariant> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariant ... productionVariants) {
            this.productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        public final void setProductionVariants(Collection<ProductionVariant.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copyFromBuilder(productionVariants);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeEndpointConfigResponse build() {
            return new DescribeEndpointConfigResponse(this);
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    CopyableBuilder<Builder, DescribeEndpointConfigResponse> {
        public Builder endpointConfigName(String var1);

        public Builder endpointConfigArn(String var1);

        public Builder productionVariants(Collection<ProductionVariant> var1);

        public Builder productionVariants(ProductionVariant ... var1);

        public Builder creationTime(Instant var1);
    }
}

