/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.TransformS3DataSource;

public class TransformS3DataSourceUnmarshaller
implements Unmarshaller<TransformS3DataSource, JsonUnmarshallerContext> {
    private static final TransformS3DataSourceUnmarshaller INSTANCE = new TransformS3DataSourceUnmarshaller();

    public TransformS3DataSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        TransformS3DataSource.Builder transformS3DataSourceBuilder = TransformS3DataSource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3DataType", targetDepth)) {
                    context.nextToken();
                    transformS3DataSourceBuilder.s3DataType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3Uri", targetDepth)) {
                    context.nextToken();
                    transformS3DataSourceBuilder.s3Uri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TransformS3DataSource)transformS3DataSourceBuilder.build();
    }

    public static TransformS3DataSourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

