/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.TransformS3DataSource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransformS3DataSourceMarshaller {
    private static final MarshallingInfo<String> S3DATATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DataType").isBinary(false).build();
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").isBinary(false).build();
    private static final TransformS3DataSourceMarshaller INSTANCE = new TransformS3DataSourceMarshaller();

    private TransformS3DataSourceMarshaller() {
    }

    public static TransformS3DataSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TransformS3DataSource transformS3DataSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)transformS3DataSource, (String)"transformS3DataSource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)transformS3DataSource.s3DataTypeAsString(), S3DATATYPE_BINDING);
            protocolMarshaller.marshall((Object)transformS3DataSource.s3Uri(), S3URI_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

