/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.TransformResources;

public class TransformResourcesUnmarshaller
implements Unmarshaller<TransformResources, JsonUnmarshallerContext> {
    private static final TransformResourcesUnmarshaller INSTANCE = new TransformResourcesUnmarshaller();

    public TransformResources unmarshall(JsonUnmarshallerContext context) throws Exception {
        TransformResources.Builder transformResourcesBuilder = TransformResources.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    transformResourcesBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceCount", targetDepth)) {
                    context.nextToken();
                    transformResourcesBuilder.instanceCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("VolumeKmsKeyId", targetDepth)) {
                    context.nextToken();
                    transformResourcesBuilder.volumeKmsKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TransformResources)transformResourcesBuilder.build();
    }

    public static TransformResourcesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

