/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sagemaker.model.TransformInput;
import software.amazon.awssdk.services.sagemaker.transform.TransformDataSourceUnmarshaller;

public class TransformInputUnmarshaller
implements Unmarshaller<TransformInput, JsonUnmarshallerContext> {
    private static final TransformInputUnmarshaller INSTANCE = new TransformInputUnmarshaller();

    public TransformInput unmarshall(JsonUnmarshallerContext context) throws Exception {
        TransformInput.Builder transformInputBuilder = TransformInput.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DataSource", targetDepth)) {
                    context.nextToken();
                    transformInputBuilder.dataSource(TransformDataSourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ContentType", targetDepth)) {
                    context.nextToken();
                    transformInputBuilder.contentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CompressionType", targetDepth)) {
                    context.nextToken();
                    transformInputBuilder.compressionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SplitType", targetDepth)) {
                    context.nextToken();
                    transformInputBuilder.splitType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TransformInput)transformInputBuilder.build();
    }

    public static TransformInputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

