/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SecondaryStatusTransitionMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").isBinary(false).build();
    private static final SecondaryStatusTransitionMarshaller INSTANCE = new SecondaryStatusTransitionMarshaller();

    private SecondaryStatusTransitionMarshaller() {
    }

    public static SecondaryStatusTransitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecondaryStatusTransition secondaryStatusTransition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)secondaryStatusTransition, (String)"secondaryStatusTransition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)secondaryStatusTransition.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)secondaryStatusTransition.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)secondaryStatusTransition.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)secondaryStatusTransition.statusMessage(), STATUSMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

