/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.ObjectiveStatusCounters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ObjectiveStatusCountersMarshaller {
    private static final MarshallingInfo<Integer> SUCCEEDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Succeeded").isBinary(false).build();
    private static final MarshallingInfo<Integer> PENDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pending").isBinary(false).build();
    private static final MarshallingInfo<Integer> FAILED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Failed").isBinary(false).build();
    private static final ObjectiveStatusCountersMarshaller INSTANCE = new ObjectiveStatusCountersMarshaller();

    private ObjectiveStatusCountersMarshaller() {
    }

    public static ObjectiveStatusCountersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ObjectiveStatusCounters objectiveStatusCounters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)objectiveStatusCounters, (String)"objectiveStatusCounters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)objectiveStatusCounters.succeeded(), SUCCEEDED_BINDING);
            protocolMarshaller.marshall((Object)objectiveStatusCounters.pending(), PENDING_BINDING);
            protocolMarshaller.marshall((Object)objectiveStatusCounters.failed(), FAILED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

