/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.DeployedImage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeployedImageMarshaller {
    private static final MarshallingInfo<String> SPECIFIEDIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpecifiedImage").isBinary(false).build();
    private static final MarshallingInfo<String> RESOLVEDIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResolvedImage").isBinary(false).build();
    private static final MarshallingInfo<Instant> RESOLUTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResolutionTime").isBinary(false).build();
    private static final DeployedImageMarshaller INSTANCE = new DeployedImageMarshaller();

    private DeployedImageMarshaller() {
    }

    public static DeployedImageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeployedImage deployedImage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deployedImage, (String)"deployedImage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deployedImage.specifiedImage(), SPECIFIEDIMAGE_BINDING);
            protocolMarshaller.marshall((Object)deployedImage.resolvedImage(), RESOLVEDIMAGE_BINDING);
            protocolMarshaller.marshall((Object)deployedImage.resolutionTime(), RESOLUTIONTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

