/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.sagemaker.model.InstanceType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNotebookInstanceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateNotebookInstanceRequest> {
    private final String notebookInstanceName;
    private final String instanceType;
    private final String roleArn;
    private final String lifecycleConfigName;
    private final Boolean disassociateLifecycleConfig;

    private UpdateNotebookInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceName = builder.notebookInstanceName;
        this.instanceType = builder.instanceType;
        this.roleArn = builder.roleArn;
        this.lifecycleConfigName = builder.lifecycleConfigName;
        this.disassociateLifecycleConfig = builder.disassociateLifecycleConfig;
    }

    public String notebookInstanceName() {
        return this.notebookInstanceName;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String lifecycleConfigName() {
        return this.lifecycleConfigName;
    }

    public Boolean disassociateLifecycleConfig() {
        return this.disassociateLifecycleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociateLifecycleConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotebookInstanceRequest)) {
            return false;
        }
        UpdateNotebookInstanceRequest other = (UpdateNotebookInstanceRequest)((Object)obj);
        return Objects.equals(this.notebookInstanceName(), other.notebookInstanceName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.lifecycleConfigName(), other.lifecycleConfigName()) && Objects.equals(this.disassociateLifecycleConfig(), other.disassociateLifecycleConfig());
    }

    public String toString() {
        return ToString.builder((String)"UpdateNotebookInstanceRequest").add("NotebookInstanceName", (Object)this.notebookInstanceName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("RoleArn", (Object)this.roleArn()).add("LifecycleConfigName", (Object)this.lifecycleConfigName()).add("DisassociateLifecycleConfig", (Object)this.disassociateLifecycleConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "LifecycleConfigName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfigName()));
            }
            case "DisassociateLifecycleConfig": {
                return Optional.ofNullable(clazz.cast(this.disassociateLifecycleConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String notebookInstanceName;
        private String instanceType;
        private String roleArn;
        private String lifecycleConfigName;
        private Boolean disassociateLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotebookInstanceRequest model) {
            super(model);
            this.notebookInstanceName(model.notebookInstanceName);
            this.instanceType(model.instanceType);
            this.roleArn(model.roleArn);
            this.lifecycleConfigName(model.lifecycleConfigName);
            this.disassociateLifecycleConfig(model.disassociateLifecycleConfig);
        }

        public final String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLifecycleConfigName() {
            return this.lifecycleConfigName;
        }

        @Override
        public final Builder lifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
            return this;
        }

        public final void setLifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
        }

        public final Boolean getDisassociateLifecycleConfig() {
            return this.disassociateLifecycleConfig;
        }

        @Override
        public final Builder disassociateLifecycleConfig(Boolean disassociateLifecycleConfig) {
            this.disassociateLifecycleConfig = disassociateLifecycleConfig;
            return this;
        }

        public final void setDisassociateLifecycleConfig(Boolean disassociateLifecycleConfig) {
            this.disassociateLifecycleConfig = disassociateLifecycleConfig;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotebookInstanceRequest build() {
            return new UpdateNotebookInstanceRequest(this);
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    CopyableBuilder<Builder, UpdateNotebookInstanceRequest> {
        public Builder notebookInstanceName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder roleArn(String var1);

        public Builder lifecycleConfigName(String var1);

        public Builder disassociateLifecycleConfig(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

