/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MetricDefinition;
import software.amazon.awssdk.services.sagemaker.model.MetricDefinitionListCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingInputMode;
import software.amazon.awssdk.services.sagemaker.transform.HyperParameterAlgorithmSpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterAlgorithmSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, HyperParameterAlgorithmSpecification> {
    private final String trainingImage;
    private final String trainingInputMode;
    private final List<MetricDefinition> metricDefinitions;

    private HyperParameterAlgorithmSpecification(BuilderImpl builder) {
        this.trainingImage = builder.trainingImage;
        this.trainingInputMode = builder.trainingInputMode;
        this.metricDefinitions = builder.metricDefinitions;
    }

    public String trainingImage() {
        return this.trainingImage;
    }

    public TrainingInputMode trainingInputMode() {
        return TrainingInputMode.fromValue(this.trainingInputMode);
    }

    public String trainingInputModeAsString() {
        return this.trainingInputMode;
    }

    public List<MetricDefinition> metricDefinitions() {
        return this.metricDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingInputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDefinitions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterAlgorithmSpecification)) {
            return false;
        }
        HyperParameterAlgorithmSpecification other = (HyperParameterAlgorithmSpecification)obj;
        return Objects.equals(this.trainingImage(), other.trainingImage()) && Objects.equals(this.trainingInputModeAsString(), other.trainingInputModeAsString()) && Objects.equals(this.metricDefinitions(), other.metricDefinitions());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterAlgorithmSpecification").add("TrainingImage", (Object)this.trainingImage()).add("TrainingInputMode", (Object)this.trainingInputModeAsString()).add("MetricDefinitions", this.metricDefinitions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingImage": {
                return Optional.ofNullable(clazz.cast(this.trainingImage()));
            }
            case "TrainingInputMode": {
                return Optional.ofNullable(clazz.cast(this.trainingInputModeAsString()));
            }
            case "MetricDefinitions": {
                return Optional.ofNullable(clazz.cast(this.metricDefinitions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HyperParameterAlgorithmSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingImage;
        private String trainingInputMode;
        private List<MetricDefinition> metricDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterAlgorithmSpecification model) {
            this.trainingImage(model.trainingImage);
            this.trainingInputMode(model.trainingInputMode);
            this.metricDefinitions(model.metricDefinitions);
        }

        public final String getTrainingImage() {
            return this.trainingImage;
        }

        @Override
        public final Builder trainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
            return this;
        }

        public final void setTrainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
        }

        public final String getTrainingInputMode() {
            return this.trainingInputMode;
        }

        @Override
        public final Builder trainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        @Override
        public final Builder trainingInputMode(TrainingInputMode trainingInputMode) {
            this.trainingInputMode(trainingInputMode.toString());
            return this;
        }

        public final void setTrainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
        }

        public final Collection<MetricDefinition.Builder> getMetricDefinitions() {
            return this.metricDefinitions != null ? (Collection)this.metricDefinitions.stream().map(MetricDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricDefinitions(Collection<MetricDefinition> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionListCopier.copy(metricDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(MetricDefinition ... metricDefinitions) {
            this.metricDefinitions(Arrays.asList(metricDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... metricDefinitions) {
            this.metricDefinitions(Stream.of(metricDefinitions).map(c -> (MetricDefinition)((MetricDefinition.Builder)MetricDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricDefinitions(Collection<MetricDefinition.BuilderImpl> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionListCopier.copyFromBuilder(metricDefinitions);
        }

        public HyperParameterAlgorithmSpecification build() {
            return new HyperParameterAlgorithmSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HyperParameterAlgorithmSpecification> {
        public Builder trainingImage(String var1);

        public Builder trainingInputMode(String var1);

        public Builder trainingInputMode(TrainingInputMode var1);

        public Builder metricDefinitions(Collection<MetricDefinition> var1);

        public Builder metricDefinitions(MetricDefinition ... var1);

        public Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... var1);
    }
}

