/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sagemaker.transform.DeployedImageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeployedImage
implements StructuredPojo,
ToCopyableBuilder<Builder, DeployedImage> {
    private final String specifiedImage;
    private final String resolvedImage;
    private final Instant resolutionTime;

    private DeployedImage(BuilderImpl builder) {
        this.specifiedImage = builder.specifiedImage;
        this.resolvedImage = builder.resolvedImage;
        this.resolutionTime = builder.resolutionTime;
    }

    public String specifiedImage() {
        return this.specifiedImage;
    }

    public String resolvedImage() {
        return this.resolvedImage;
    }

    public Instant resolutionTime() {
        return this.resolutionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.specifiedImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployedImage)) {
            return false;
        }
        DeployedImage other = (DeployedImage)obj;
        return Objects.equals(this.specifiedImage(), other.specifiedImage()) && Objects.equals(this.resolvedImage(), other.resolvedImage()) && Objects.equals(this.resolutionTime(), other.resolutionTime());
    }

    public String toString() {
        return ToString.builder((String)"DeployedImage").add("SpecifiedImage", (Object)this.specifiedImage()).add("ResolvedImage", (Object)this.resolvedImage()).add("ResolutionTime", (Object)this.resolutionTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpecifiedImage": {
                return Optional.ofNullable(clazz.cast(this.specifiedImage()));
            }
            case "ResolvedImage": {
                return Optional.ofNullable(clazz.cast(this.resolvedImage()));
            }
            case "ResolutionTime": {
                return Optional.ofNullable(clazz.cast(this.resolutionTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeployedImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String specifiedImage;
        private String resolvedImage;
        private Instant resolutionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeployedImage model) {
            this.specifiedImage(model.specifiedImage);
            this.resolvedImage(model.resolvedImage);
            this.resolutionTime(model.resolutionTime);
        }

        public final String getSpecifiedImage() {
            return this.specifiedImage;
        }

        @Override
        public final Builder specifiedImage(String specifiedImage) {
            this.specifiedImage = specifiedImage;
            return this;
        }

        public final void setSpecifiedImage(String specifiedImage) {
            this.specifiedImage = specifiedImage;
        }

        public final String getResolvedImage() {
            return this.resolvedImage;
        }

        @Override
        public final Builder resolvedImage(String resolvedImage) {
            this.resolvedImage = resolvedImage;
            return this;
        }

        public final void setResolvedImage(String resolvedImage) {
            this.resolvedImage = resolvedImage;
        }

        public final Instant getResolutionTime() {
            return this.resolutionTime;
        }

        @Override
        public final Builder resolutionTime(Instant resolutionTime) {
            this.resolutionTime = resolutionTime;
            return this;
        }

        public final void setResolutionTime(Instant resolutionTime) {
            this.resolutionTime = resolutionTime;
        }

        public DeployedImage build() {
            return new DeployedImage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeployedImage> {
        public Builder specifiedImage(String var1);

        public Builder resolvedImage(String var1);

        public Builder resolutionTime(Instant var1);
    }
}

