/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndpointConfigSummaryMarshaller {
    private static final MarshallingInfo<String> ENDPOINTCONFIGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointConfigName").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTCONFIGARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointConfigArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final EndpointConfigSummaryMarshaller INSTANCE = new EndpointConfigSummaryMarshaller();

    private EndpointConfigSummaryMarshaller() {
    }

    public static EndpointConfigSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointConfigSummary endpointConfigSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)endpointConfigSummary, (String)"endpointConfigSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)endpointConfigSummary.endpointConfigName(), ENDPOINTCONFIGNAME_BINDING);
            protocolMarshaller.marshall((Object)endpointConfigSummary.endpointConfigArn(), ENDPOINTCONFIGARN_BINDING);
            protocolMarshaller.marshall((Object)endpointConfigSummary.creationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

