/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;

public class ListTrainingJobsIterable
implements SdkIterable<ListTrainingJobsResponse> {
    private final SageMakerClient client;
    private final ListTrainingJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrainingJobsIterable(SageMakerClient client, ListTrainingJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTrainingJobsResponseFetcher();
    }

    public Iterator<ListTrainingJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListTrainingJobsIterable resume(ListTrainingJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTrainingJobsIterable(this.client, (ListTrainingJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTrainingJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTrainingJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTrainingJobsResponseFetcher
    implements SyncPageFetcher<ListTrainingJobsResponse> {
        private ListTrainingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainingJobsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListTrainingJobsResponse nextPage(ListTrainingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTrainingJobsIterable.this.client.listTrainingJobs(ListTrainingJobsIterable.this.firstRequest);
            }
            return ListTrainingJobsIterable.this.client.listTrainingJobs((ListTrainingJobsRequest)((Object)ListTrainingJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

