/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.VectorData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryVectorsRequest
extends S3VectorsRequest
implements ToCopyableBuilder<Builder, QueryVectorsRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorBucketName").getter(QueryVectorsRequest.getter(QueryVectorsRequest::vectorBucketName)).setter(QueryVectorsRequest.setter(Builder::vectorBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(QueryVectorsRequest.getter(QueryVectorsRequest::indexName)).setter(QueryVectorsRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexArn").getter(QueryVectorsRequest.getter(QueryVectorsRequest::indexArn)).setter(QueryVectorsRequest.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()}).build();
    private static final SdkField<Integer> TOPK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("topK").getter(QueryVectorsRequest.getter(QueryVectorsRequest::topK)).setter(QueryVectorsRequest.setter(Builder::topK)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()}).build();
    private static final SdkField<VectorData> QUERY_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queryVector").getter(QueryVectorsRequest.getter(QueryVectorsRequest::queryVector)).setter(QueryVectorsRequest.setter(Builder::queryVector)).constructor(VectorData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVector").build()}).build();
    private static final SdkField<Document> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("filter").getter(QueryVectorsRequest.getter(QueryVectorsRequest::filter)).setter(QueryVectorsRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<Boolean> RETURN_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("returnMetadata").getter(QueryVectorsRequest.getter(QueryVectorsRequest::returnMetadata)).setter(QueryVectorsRequest.setter(Builder::returnMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnMetadata").build()}).build();
    private static final SdkField<Boolean> RETURN_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("returnDistance").getter(QueryVectorsRequest.getter(QueryVectorsRequest::returnDistance)).setter(QueryVectorsRequest.setter(Builder::returnDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnDistance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD, INDEX_NAME_FIELD, INDEX_ARN_FIELD, TOPK_FIELD, QUERY_VECTOR_FIELD, FILTER_FIELD, RETURN_METADATA_FIELD, RETURN_DISTANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryVectorsRequest.memberNameToFieldInitializer();
    private final String vectorBucketName;
    private final String indexName;
    private final String indexArn;
    private final Integer topK;
    private final VectorData queryVector;
    private final Document filter;
    private final Boolean returnMetadata;
    private final Boolean returnDistance;

    private QueryVectorsRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.topK = builder.topK;
        this.queryVector = builder.queryVector;
        this.filter = builder.filter;
        this.returnMetadata = builder.returnMetadata;
        this.returnDistance = builder.returnDistance;
    }

    public final String vectorBucketName() {
        return this.vectorBucketName;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final Integer topK() {
        return this.topK;
    }

    public final VectorData queryVector() {
        return this.queryVector;
    }

    public final Document filter() {
        return this.filter;
    }

    public final Boolean returnMetadata() {
        return this.returnMetadata;
    }

    public final Boolean returnDistance() {
        return this.returnDistance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topK());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnDistance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryVectorsRequest)) {
            return false;
        }
        QueryVectorsRequest other = (QueryVectorsRequest)((Object)obj);
        return Objects.equals(this.vectorBucketName(), other.vectorBucketName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexArn(), other.indexArn()) && Objects.equals(this.topK(), other.topK()) && Objects.equals(this.queryVector(), other.queryVector()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.returnMetadata(), other.returnMetadata()) && Objects.equals(this.returnDistance(), other.returnDistance());
    }

    public final String toString() {
        return ToString.builder((String)"QueryVectorsRequest").add("VectorBucketName", (Object)this.vectorBucketName()).add("IndexName", (Object)this.indexName()).add("IndexArn", (Object)this.indexArn()).add("TopK", (Object)this.topK()).add("QueryVector", (Object)this.queryVector()).add("Filter", (Object)this.filter()).add("ReturnMetadata", (Object)this.returnMetadata()).add("ReturnDistance", (Object)this.returnDistance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vectorBucketName": {
                return Optional.ofNullable(clazz.cast(this.vectorBucketName()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "indexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "topK": {
                return Optional.ofNullable(clazz.cast(this.topK()));
            }
            case "queryVector": {
                return Optional.ofNullable(clazz.cast(this.queryVector()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "returnMetadata": {
                return Optional.ofNullable(clazz.cast(this.returnMetadata()));
            }
            case "returnDistance": {
                return Optional.ofNullable(clazz.cast(this.returnDistance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("topK", TOPK_FIELD);
        map.put("queryVector", QUERY_VECTOR_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("returnMetadata", RETURN_METADATA_FIELD);
        map.put("returnDistance", RETURN_DISTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryVectorsRequest, T> g) {
        return obj -> g.apply((QueryVectorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3VectorsRequest.BuilderImpl
    implements Builder {
        private String vectorBucketName;
        private String indexName;
        private String indexArn;
        private Integer topK;
        private VectorData queryVector;
        private Document filter;
        private Boolean returnMetadata;
        private Boolean returnDistance;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryVectorsRequest model) {
            super(model);
            this.vectorBucketName(model.vectorBucketName);
            this.indexName(model.indexName);
            this.indexArn(model.indexArn);
            this.topK(model.topK);
            this.queryVector(model.queryVector);
            this.filter(model.filter);
            this.returnMetadata(model.returnMetadata);
            this.returnDistance(model.returnDistance);
        }

        public final String getVectorBucketName() {
            return this.vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Integer getTopK() {
            return this.topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public final VectorData.Builder getQueryVector() {
            return this.queryVector != null ? this.queryVector.toBuilder() : null;
        }

        public final void setQueryVector(VectorData.BuilderImpl queryVector) {
            this.queryVector = queryVector != null ? queryVector.build() : null;
        }

        @Override
        public final Builder queryVector(VectorData queryVector) {
            this.queryVector = queryVector;
            return this;
        }

        public final Document getFilter() {
            return this.filter;
        }

        public final void setFilter(Document filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(Document filter) {
            this.filter = filter;
            return this;
        }

        public final Boolean getReturnMetadata() {
            return this.returnMetadata;
        }

        public final void setReturnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
        }

        @Override
        public final Builder returnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
            return this;
        }

        public final Boolean getReturnDistance() {
            return this.returnDistance;
        }

        public final void setReturnDistance(Boolean returnDistance) {
            this.returnDistance = returnDistance;
        }

        @Override
        public final Builder returnDistance(Boolean returnDistance) {
            this.returnDistance = returnDistance;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryVectorsRequest build() {
            return new QueryVectorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3VectorsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryVectorsRequest> {
        public Builder vectorBucketName(String var1);

        public Builder indexName(String var1);

        public Builder indexArn(String var1);

        public Builder topK(Integer var1);

        public Builder queryVector(VectorData var1);

        default public Builder queryVector(Consumer<VectorData.Builder> queryVector) {
            return this.queryVector((VectorData)((VectorData.Builder)VectorData.builder().applyMutation(queryVector)).build());
        }

        public Builder filter(Document var1);

        public Builder returnMetadata(Boolean var1);

        public Builder returnDistance(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

