/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.s3vectors.model.AccessDeniedException;
import software.amazon.awssdk.services.s3vectors.model.ConflictException;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.GetIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.GetIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.InternalServerException;
import software.amazon.awssdk.services.s3vectors.model.KmsDisabledException;
import software.amazon.awssdk.services.s3vectors.model.KmsInvalidKeyUsageException;
import software.amazon.awssdk.services.s3vectors.model.KmsInvalidStateException;
import software.amazon.awssdk.services.s3vectors.model.KmsNotFoundException;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse;
import software.amazon.awssdk.services.s3vectors.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.s3vectors.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.NotFoundException;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.RequestTimeoutException;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsException;
import software.amazon.awssdk.services.s3vectors.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.s3vectors.model.ServiceUnavailableException;
import software.amazon.awssdk.services.s3vectors.model.TagResourceRequest;
import software.amazon.awssdk.services.s3vectors.model.TagResourceResponse;
import software.amazon.awssdk.services.s3vectors.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3vectors.model.UntagResourceRequest;
import software.amazon.awssdk.services.s3vectors.model.UntagResourceResponse;
import software.amazon.awssdk.services.s3vectors.model.ValidationException;
import software.amazon.awssdk.services.s3vectors.paginators.ListIndexesIterable;
import software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsIterable;
import software.amazon.awssdk.services.s3vectors.paginators.ListVectorsIterable;

/**
 * Service client for accessing Amazon S3 Vectors. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon S3 vector buckets are a bucket type to store and search vectors with sub-second search times. They are
 * designed to provide dedicated API operations for you to interact with vectors to do similarity search. Within a
 * vector bucket, you use a vector index to organize and logically group your vector data. When you make a write or read
 * request, you direct it to a single vector index. You store your vector data as vectors. A vector contains a key (a
 * name that you assign), a multi-dimensional vector, and, optionally, metadata that describes a vector. The key
 * uniquely identifies the vector in a vector index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface S3VectorsClient extends AwsClient {
    String SERVICE_NAME = "s3vectors";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "s3vectors";

    /**
     * <p>
     * Creates a vector index within a vector bucket. To specify the vector bucket, you must use either the vector
     * bucket name or the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:CreateIndex</code> permission to use this operation.
     * </p>
     * <p>
     * You must have the <code>s3vectors:TagResource</code> permission in addition to <code>s3vectors:CreateIndex</code>
     * permission to create a vector index with tags.
     * </p>
     * </dd>
     * </dl>
     *
     * @param createIndexRequest
     * @return Result of the CreateIndex operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, ConflictException, NotFoundException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a vector index within a vector bucket. To specify the vector bucket, you must use either the vector
     * bucket name or the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:CreateIndex</code> permission to use this operation.
     * </p>
     * <p>
     * You must have the <code>s3vectors:TagResource</code> permission in addition to <code>s3vectors:CreateIndex</code>
     * permission to create a vector index with tags.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.CreateIndexRequest.Builder} to create a request.
     * @return Result of the CreateIndex operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIndexResponse createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, ConflictException, NotFoundException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, S3VectorsException {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * Creates a vector bucket in the Amazon Web Services Region that you want your bucket to be in.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:CreateVectorBucket</code> permission to use this operation.
     * </p>
     * <p>
     * You must have the <code>s3vectors:TagResource</code> permission in addition to
     * <code>s3vectors:CreateVectorBucket</code> permission to create a vector bucket with tags.
     * </p>
     * </dd>
     * </dl>
     *
     * @param createVectorBucketRequest
     * @return Result of the CreateVectorBucket operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.CreateVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/CreateVectorBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVectorBucketResponse createVectorBucket(CreateVectorBucketRequest createVectorBucketRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a vector bucket in the Amazon Web Services Region that you want your bucket to be in.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:CreateVectorBucket</code> permission to use this operation.
     * </p>
     * <p>
     * You must have the <code>s3vectors:TagResource</code> permission in addition to
     * <code>s3vectors:CreateVectorBucket</code> permission to create a vector bucket with tags.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVectorBucketRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVectorBucketRequest#builder()}
     * </p>
     *
     * @param createVectorBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVectorBucket operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.CreateVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/CreateVectorBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVectorBucketResponse createVectorBucket(Consumer<CreateVectorBucketRequest.Builder> createVectorBucketRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, S3VectorsException {
        return createVectorBucket(CreateVectorBucketRequest.builder().applyMutation(createVectorBucketRequest).build());
    }

    /**
     * <p>
     * Deletes a vector index. To specify the vector index, you can either use both the vector bucket name and vector
     * index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteIndexRequest
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a vector index. To specify the vector index, you can either use both the vector bucket name and vector
     * index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIndexRequest#builder()}
     * </p>
     *
     * @param deleteIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.DeleteIndexRequest.Builder} to create a request.
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return deleteIndex(DeleteIndexRequest.builder().applyMutation(deleteIndexRequest).build());
    }

    /**
     * <p>
     * Deletes a vector bucket. All vector indexes in the vector bucket must be deleted before the vector bucket can be
     * deleted. To perform this operation, you must use either the vector bucket name or the vector bucket Amazon
     * Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteVectorBucketRequest
     * @return Result of the DeleteVectorBucket operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.DeleteVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectorBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVectorBucketResponse deleteVectorBucket(DeleteVectorBucketRequest deleteVectorBucketRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, ConflictException, NotFoundException, AwsServiceException,
            SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a vector bucket. All vector indexes in the vector bucket must be deleted before the vector bucket can be
     * deleted. To perform this operation, you must use either the vector bucket name or the vector bucket Amazon
     * Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVectorBucketRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVectorBucketRequest#builder()}
     * </p>
     *
     * @param deleteVectorBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVectorBucket operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.DeleteVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectorBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVectorBucketResponse deleteVectorBucket(Consumer<DeleteVectorBucketRequest.Builder> deleteVectorBucketRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, ConflictException, NotFoundException, AwsServiceException,
            SdkClientException, S3VectorsException {
        return deleteVectorBucket(DeleteVectorBucketRequest.builder().applyMutation(deleteVectorBucketRequest).build());
    }

    /**
     * <p>
     * Deletes a vector bucket policy. To specify the bucket, you must use either the vector bucket name or the vector
     * bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteVectorBucketPolicyRequest
     * @return Result of the DeleteVectorBucketPolicy operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.DeleteVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVectorBucketPolicyResponse deleteVectorBucketPolicy(
            DeleteVectorBucketPolicyRequest deleteVectorBucketPolicyRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a vector bucket policy. To specify the bucket, you must use either the vector bucket name or the vector
     * bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVectorBucketPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVectorBucketPolicyRequest#builder()}
     * </p>
     *
     * @param deleteVectorBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteVectorBucketPolicy operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.DeleteVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVectorBucketPolicyResponse deleteVectorBucketPolicy(
            Consumer<DeleteVectorBucketPolicyRequest.Builder> deleteVectorBucketPolicyRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return deleteVectorBucketPolicy(DeleteVectorBucketPolicyRequest.builder().applyMutation(deleteVectorBucketPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes one or more vectors in a vector index. To specify the vector index, you can either use both the vector
     * bucket name and vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteVectorsRequest
     * @return Result of the DeleteVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws KmsInvalidKeyUsageException
     *         The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws KmsInvalidStateException
     *         The key state of the KMS key isn't compatible with the operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws KmsNotFoundException
     *         The KMS key can't be found.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws KmsDisabledException
     *         The specified Amazon Web Services KMS key isn't enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.DeleteVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVectorsResponse deleteVectors(DeleteVectorsRequest deleteVectorsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException,
            KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException,
            KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more vectors in a vector index. To specify the vector index, you can either use both the vector
     * bucket name and vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVectorsRequest#builder()}
     * </p>
     *
     * @param deleteVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.DeleteVectorsRequest.Builder} to create a request.
     * @return Result of the DeleteVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws KmsInvalidKeyUsageException
     *         The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws KmsInvalidStateException
     *         The key state of the KMS key isn't compatible with the operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws KmsNotFoundException
     *         The KMS key can't be found.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws KmsDisabledException
     *         The specified Amazon Web Services KMS key isn't enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.DeleteVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVectorsResponse deleteVectors(Consumer<DeleteVectorsRequest.Builder> deleteVectorsRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException,
            InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException,
            RequestTimeoutException, NotFoundException, KmsDisabledException, AwsServiceException, SdkClientException,
            S3VectorsException {
        return deleteVectors(DeleteVectorsRequest.builder().applyMutation(deleteVectorsRequest).build());
    }

    /**
     * <p>
     * Returns vector index attributes. To specify the vector index, you can either use both the vector bucket name and
     * the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getIndexRequest
     * @return Result of the GetIndex operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIndexResponse getIndex(GetIndexRequest getIndexRequest) throws ValidationException, ServiceUnavailableException,
            TooManyRequestsException, InternalServerException, AccessDeniedException, RequestTimeoutException, NotFoundException,
            AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns vector index attributes. To specify the vector index, you can either use both the vector bucket name and
     * the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIndexRequest.Builder} avoiding the need to
     * create one manually via {@link GetIndexRequest#builder()}
     * </p>
     *
     * @param getIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.GetIndexRequest.Builder} to create a request.
     * @return Result of the GetIndex operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIndexResponse getIndex(Consumer<GetIndexRequest.Builder> getIndexRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return getIndex(GetIndexRequest.builder().applyMutation(getIndexRequest).build());
    }

    /**
     * <p>
     * Returns vector bucket attributes. To specify the bucket, you must use either the vector bucket name or the vector
     * bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getVectorBucketRequest
     * @return Result of the GetVectorBucket operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.GetVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectorBucket" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVectorBucketResponse getVectorBucket(GetVectorBucketRequest getVectorBucketRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns vector bucket attributes. To specify the bucket, you must use either the vector bucket name or the vector
     * bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVectorBucketRequest.Builder} avoiding the need
     * to create one manually via {@link GetVectorBucketRequest#builder()}
     * </p>
     *
     * @param getVectorBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.GetVectorBucketRequest.Builder} to create a
     *        request.
     * @return Result of the GetVectorBucket operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.GetVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectorBucket" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVectorBucketResponse getVectorBucket(Consumer<GetVectorBucketRequest.Builder> getVectorBucketRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException,
            S3VectorsException {
        return getVectorBucket(GetVectorBucketRequest.builder().applyMutation(getVectorBucketRequest).build());
    }

    /**
     * <p>
     * Gets details about a vector bucket policy. To specify the bucket, you must use either the vector bucket name or
     * the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getVectorBucketPolicyRequest
     * @return Result of the GetVectorBucketPolicy operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.GetVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVectorBucketPolicyResponse getVectorBucketPolicy(GetVectorBucketPolicyRequest getVectorBucketPolicyRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException,
            S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a vector bucket policy. To specify the bucket, you must use either the vector bucket name or
     * the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVectorBucketPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetVectorBucketPolicyRequest#builder()}
     * </p>
     *
     * @param getVectorBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetVectorBucketPolicy operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.GetVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetVectorBucketPolicyResponse getVectorBucketPolicy(
            Consumer<GetVectorBucketPolicyRequest.Builder> getVectorBucketPolicyRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return getVectorBucketPolicy(GetVectorBucketPolicyRequest.builder().applyMutation(getVectorBucketPolicyRequest).build());
    }

    /**
     * <p>
     * Returns vector attributes. To specify the vector index, you can either use both the vector bucket name and the
     * vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getVectorsRequest
     * @return Result of the GetVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws KmsInvalidKeyUsageException
     *         The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws KmsInvalidStateException
     *         The key state of the KMS key isn't compatible with the operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws KmsNotFoundException
     *         The KMS key can't be found.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws KmsDisabledException
     *         The specified Amazon Web Services KMS key isn't enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.GetVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVectorsResponse getVectors(GetVectorsRequest getVectorsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException,
            KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException,
            KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns vector attributes. To specify the vector index, you can either use both the vector bucket name and the
     * vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetVectorsRequest#builder()}
     * </p>
     *
     * @param getVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.GetVectorsRequest.Builder} to create a request.
     * @return Result of the GetVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws KmsInvalidKeyUsageException
     *         The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws KmsInvalidStateException
     *         The key state of the KMS key isn't compatible with the operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws KmsNotFoundException
     *         The KMS key can't be found.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws KmsDisabledException
     *         The specified Amazon Web Services KMS key isn't enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.GetVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVectorsResponse getVectors(Consumer<GetVectorsRequest.Builder> getVectorsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException,
            KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException,
            KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        return getVectors(GetVectorsRequest.builder().applyMutation(getVectorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the vector indexes within the specified vector bucket. To specify the bucket, you must use
     * either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListIndexes</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param listIndexesRequest
     * @return Result of the ListIndexes operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndexesResponse listIndexes(ListIndexesRequest listIndexesRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the vector indexes within the specified vector bucket. To specify the bucket, you must use
     * either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListIndexes</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexesRequest#builder()}
     * </p>
     *
     * @param listIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest.Builder} to create a request.
     * @return Result of the ListIndexes operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndexesResponse listIndexes(Consumer<ListIndexesRequest.Builder> listIndexesRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return listIndexes(ListIndexesRequest.builder().applyMutation(listIndexesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listIndexes(software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3vectors.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     *     for (software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexes(software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest)} operation.</b>
     * </p>
     *
     * @param listIndexesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndexesIterable listIndexesPaginator(ListIndexesRequest listIndexesRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return new ListIndexesIterable(this, listIndexesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listIndexes(software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3vectors.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     *     for (software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListIndexesIterable responses = client.listIndexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexes(software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexesRequest#builder()}
     * </p>
     *
     * @param listIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndexesIterable listIndexesPaginator(Consumer<ListIndexesRequest.Builder> listIndexesRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException,
            S3VectorsException {
        return listIndexesPaginator(ListIndexesRequest.builder().applyMutation(listIndexesRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags applied to a specified Amazon S3 Vectors resource. Each tag is a label consisting of a key
     * and value pair. Tags can help you organize, track costs for, and control access to resources.
     * </p>
     * <note>
     * <p>
     * For a list of S3 resources that support tagging, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html#manage-tags">Managing tags for Amazon S3
     * resources</a>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * For vector buckets and vector indexes, you must have the <code>s3vectors:ListTagsForResource</code> permission to
     * use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException,
            S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags applied to a specified Amazon S3 Vectors resource. Each tag is a label consisting of a key
     * and value pair. Tags can help you organize, track costs for, and control access to resources.
     * </p>
     * <note>
     * <p>
     * For a list of S3 resources that support tagging, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html#manage-tags">Managing tags for Amazon S3
     * resources</a>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * For vector buckets and vector indexes, you must have the <code>s3vectors:ListTagsForResource</code> permission to
     * use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the vector buckets that are owned by the authenticated sender of the request.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListVectorBuckets</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param listVectorBucketsRequest
     * @return Result of the ListVectorBuckets operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListVectorBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectorBuckets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVectorBucketsResponse listVectorBuckets(ListVectorBucketsRequest listVectorBucketsRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the vector buckets that are owned by the authenticated sender of the request.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListVectorBuckets</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVectorBucketsRequest#builder()}
     * </p>
     *
     * @param listVectorBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest.Builder} to create a
     *        request.
     * @return Result of the ListVectorBuckets operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListVectorBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectorBuckets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVectorBucketsResponse listVectorBuckets(Consumer<ListVectorBucketsRequest.Builder> listVectorBucketsRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, S3VectorsException {
        return listVectorBuckets(ListVectorBucketsRequest.builder().applyMutation(listVectorBucketsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVectorBuckets(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsIterable responses = client.listVectorBucketsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsIterable responses = client
     *             .listVectorBucketsPaginator(request);
     *     for (software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsIterable responses = client.listVectorBucketsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectorBuckets(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVectorBucketsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListVectorBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectorBuckets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVectorBucketsIterable listVectorBucketsPaginator(ListVectorBucketsRequest listVectorBucketsRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, S3VectorsException {
        return new ListVectorBucketsIterable(this, listVectorBucketsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVectorBuckets(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsIterable responses = client.listVectorBucketsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsIterable responses = client
     *             .listVectorBucketsPaginator(request);
     *     for (software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsIterable responses = client.listVectorBucketsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectorBuckets(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVectorBucketsRequest#builder()}
     * </p>
     *
     * @param listVectorBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListVectorBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectorBuckets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVectorBucketsIterable listVectorBucketsPaginator(
            Consumer<ListVectorBucketsRequest.Builder> listVectorBucketsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, AwsServiceException, SdkClientException, S3VectorsException {
        return listVectorBucketsPaginator(ListVectorBucketsRequest.builder().applyMutation(listVectorBucketsRequest).build());
    }

    /**
     * <p>
     * List vectors in the specified vector index. To specify the vector index, you can either use both the vector
     * bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <p>
     * <code>ListVectors</code> operations proceed sequentially; however, for faster performance on a large number of
     * vectors in a vector index, applications can request a parallel <code>ListVectors</code> operation by providing
     * the <code>segmentCount</code> and <code>segmentIndex</code> parameters.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListVectors</code> permission to use this operation. Additional permissions are
     * required based on the request parameters you specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * With only <code>s3vectors:ListVectors</code> permission, you can list vector keys when <code>returnData</code>
     * and <code>returnMetadata</code> are both set to false or not specified..
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>returnData</code> or <code>returnMetadata</code> to true, you must have both
     * <code>s3vectors:ListVectors</code> and <code>s3vectors:GetVectors</code> permissions. The request fails with a
     * <code>403 Forbidden</code> error if you request vector data or metadata without the
     * <code>s3vectors:GetVectors</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     *
     * @param listVectorsRequest
     * @return Result of the ListVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVectorsResponse listVectors(ListVectorsRequest listVectorsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List vectors in the specified vector index. To specify the vector index, you can either use both the vector
     * bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <p>
     * <code>ListVectors</code> operations proceed sequentially; however, for faster performance on a large number of
     * vectors in a vector index, applications can request a parallel <code>ListVectors</code> operation by providing
     * the <code>segmentCount</code> and <code>segmentIndex</code> parameters.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListVectors</code> permission to use this operation. Additional permissions are
     * required based on the request parameters you specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * With only <code>s3vectors:ListVectors</code> permission, you can list vector keys when <code>returnData</code>
     * and <code>returnMetadata</code> are both set to false or not specified..
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>returnData</code> or <code>returnMetadata</code> to true, you must have both
     * <code>s3vectors:ListVectors</code> and <code>s3vectors:GetVectors</code> permissions. The request fails with a
     * <code>403 Forbidden</code> error if you request vector data or metadata without the
     * <code>s3vectors:GetVectors</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVectorsRequest#builder()}
     * </p>
     *
     * @param listVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest.Builder} to create a request.
     * @return Result of the ListVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVectorsResponse listVectors(Consumer<ListVectorsRequest.Builder> listVectorsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return listVectors(ListVectorsRequest.builder().applyMutation(listVectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listVectors(software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorsIterable responses = client.listVectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3vectors.paginators.ListVectorsIterable responses = client.listVectorsPaginator(request);
     *     for (software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorsIterable responses = client.listVectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectors(software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest)} operation.</b>
     * </p>
     *
     * @param listVectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVectorsIterable listVectorsPaginator(ListVectorsRequest listVectorsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return new ListVectorsIterable(this, listVectorsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listVectors(software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorsIterable responses = client.listVectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3vectors.paginators.ListVectorsIterable responses = client.listVectorsPaginator(request);
     *     for (software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorsIterable responses = client.listVectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectors(software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVectorsRequest#builder()}
     * </p>
     *
     * @param listVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.ListVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVectorsIterable listVectorsPaginator(Consumer<ListVectorsRequest.Builder> listVectorsRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException,
            S3VectorsException {
        return listVectorsPaginator(ListVectorsRequest.builder().applyMutation(listVectorsRequest).build());
    }

    /**
     * <p>
     * Creates a bucket policy for a vector bucket. To specify the bucket, you must use either the vector bucket name or
     * the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:PutVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param putVectorBucketPolicyRequest
     * @return Result of the PutVectorBucketPolicy operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.PutVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/PutVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutVectorBucketPolicyResponse putVectorBucketPolicy(PutVectorBucketPolicyRequest putVectorBucketPolicyRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException,
            S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a bucket policy for a vector bucket. To specify the bucket, you must use either the vector bucket name or
     * the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:PutVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVectorBucketPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutVectorBucketPolicyRequest#builder()}
     * </p>
     *
     * @param putVectorBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutVectorBucketPolicy operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.PutVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/PutVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutVectorBucketPolicyResponse putVectorBucketPolicy(
            Consumer<PutVectorBucketPolicyRequest.Builder> putVectorBucketPolicyRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, AwsServiceException, SdkClientException, S3VectorsException {
        return putVectorBucketPolicy(PutVectorBucketPolicyRequest.builder().applyMutation(putVectorBucketPolicyRequest).build());
    }

    /**
     * <p>
     * Adds one or more vectors to a vector index. To specify the vector index, you can either use both the vector
     * bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information about limits, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations and
     * restrictions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * When inserting vector data into your vector index, you must provide the vector data as <code>float32</code>
     * (32-bit floating point) values. If you pass higher-precision values to an Amazon Web Services SDK, S3 Vectors
     * converts the values to 32-bit floating point before storing them, and <code>GetVectors</code>,
     * <code>ListVectors</code>, and <code>QueryVectors</code> operations return the float32 values. Different Amazon
     * Web Services SDKs may have different default numeric types, so ensure your vectors are properly formatted as
     * <code>float32</code> values regardless of which SDK you're using. For example, in Python, use
     * <code>numpy.float32</code> or explicitly cast your values.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:PutVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param putVectorsRequest
     * @return Result of the PutVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws KmsInvalidKeyUsageException
     *         The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws KmsInvalidStateException
     *         The key state of the KMS key isn't compatible with the operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws KmsNotFoundException
     *         The KMS key can't be found.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws KmsDisabledException
     *         The specified Amazon Web Services KMS key isn't enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.PutVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/PutVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default PutVectorsResponse putVectors(PutVectorsRequest putVectorsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException,
            KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException,
            ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more vectors to a vector index. To specify the vector index, you can either use both the vector
     * bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information about limits, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations and
     * restrictions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * When inserting vector data into your vector index, you must provide the vector data as <code>float32</code>
     * (32-bit floating point) values. If you pass higher-precision values to an Amazon Web Services SDK, S3 Vectors
     * converts the values to 32-bit floating point before storing them, and <code>GetVectors</code>,
     * <code>ListVectors</code>, and <code>QueryVectors</code> operations return the float32 values. Different Amazon
     * Web Services SDKs may have different default numeric types, so ensure your vectors are properly formatted as
     * <code>float32</code> values regardless of which SDK you're using. For example, in Python, use
     * <code>numpy.float32</code> or explicitly cast your values.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:PutVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link PutVectorsRequest#builder()}
     * </p>
     *
     * @param putVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.PutVectorsRequest.Builder} to create a request.
     * @return Result of the PutVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws KmsInvalidKeyUsageException
     *         The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws KmsInvalidStateException
     *         The key state of the KMS key isn't compatible with the operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws KmsNotFoundException
     *         The KMS key can't be found.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws ServiceQuotaExceededException
     *         Your request exceeds a service quota.
     * @throws KmsDisabledException
     *         The specified Amazon Web Services KMS key isn't enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.PutVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/PutVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default PutVectorsResponse putVectors(Consumer<PutVectorsRequest.Builder> putVectorsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException,
            KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException,
            ServiceQuotaExceededException, KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        return putVectors(PutVectorsRequest.builder().applyMutation(putVectorsRequest).build());
    }

    /**
     * <p>
     * Performs an approximate nearest neighbor search query in a vector index using a query vector. By default, it
     * returns the keys of approximate nearest neighbors. You can optionally include the computed distance (between the
     * query vector and each vector in the response), the vector data, and metadata of each vector in the response.
     * </p>
     * <p>
     * To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the
     * vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:QueryVectors</code> permission to use this operation. Additional permissions
     * are required based on the request parameters you specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * With only <code>s3vectors:QueryVectors</code> permission, you can retrieve vector keys of approximate nearest
     * neighbors and computed distances between these vectors. This permission is sufficient only when you don't set any
     * metadata filters and don't request vector data or metadata (by keeping the <code>returnMetadata</code> parameter
     * set to <code>false</code> or not specified).
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a metadata filter or set <code>returnMetadata</code> to true, you must have both
     * <code>s3vectors:QueryVectors</code> and <code>s3vectors:GetVectors</code> permissions. The request fails with a
     * <code>403 Forbidden error</code> if you request metadata filtering, vector data, or metadata without the
     * <code>s3vectors:GetVectors</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     *
     * @param queryVectorsRequest
     * @return Result of the QueryVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws KmsInvalidKeyUsageException
     *         The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws KmsInvalidStateException
     *         The key state of the KMS key isn't compatible with the operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws KmsNotFoundException
     *         The KMS key can't be found.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws KmsDisabledException
     *         The specified Amazon Web Services KMS key isn't enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.QueryVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/QueryVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryVectorsResponse queryVectors(QueryVectorsRequest queryVectorsRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException, InternalServerException,
            KmsInvalidStateException, AccessDeniedException, KmsNotFoundException, RequestTimeoutException, NotFoundException,
            KmsDisabledException, AwsServiceException, SdkClientException, S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs an approximate nearest neighbor search query in a vector index using a query vector. By default, it
     * returns the keys of approximate nearest neighbors. You can optionally include the computed distance (between the
     * query vector and each vector in the response), the vector data, and metadata of each vector in the response.
     * </p>
     * <p>
     * To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the
     * vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:QueryVectors</code> permission to use this operation. Additional permissions
     * are required based on the request parameters you specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * With only <code>s3vectors:QueryVectors</code> permission, you can retrieve vector keys of approximate nearest
     * neighbors and computed distances between these vectors. This permission is sufficient only when you don't set any
     * metadata filters and don't request vector data or metadata (by keeping the <code>returnMetadata</code> parameter
     * set to <code>false</code> or not specified).
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a metadata filter or set <code>returnMetadata</code> to true, you must have both
     * <code>s3vectors:QueryVectors</code> and <code>s3vectors:GetVectors</code> permissions. The request fails with a
     * <code>403 Forbidden error</code> if you request metadata filtering, vector data, or metadata without the
     * <code>s3vectors:GetVectors</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link QueryVectorsRequest#builder()}
     * </p>
     *
     * @param queryVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.QueryVectorsRequest.Builder} to create a request.
     * @return Result of the QueryVectors operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws KmsInvalidKeyUsageException
     *         The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws KmsInvalidStateException
     *         The key state of the KMS key isn't compatible with the operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws KmsNotFoundException
     *         The KMS key can't be found.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws KmsDisabledException
     *         The specified Amazon Web Services KMS key isn't enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.QueryVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/QueryVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default QueryVectorsResponse queryVectors(Consumer<QueryVectorsRequest.Builder> queryVectorsRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, KmsInvalidKeyUsageException,
            InternalServerException, KmsInvalidStateException, AccessDeniedException, KmsNotFoundException,
            RequestTimeoutException, NotFoundException, KmsDisabledException, AwsServiceException, SdkClientException,
            S3VectorsException {
        return queryVectors(QueryVectorsRequest.builder().applyMutation(queryVectorsRequest).build());
    }

    /**
     * <p>
     * Applies one or more user-defined tags to an Amazon S3 Vectors resource or updates existing tags. Each tag is a
     * label consisting of a key and value pair. Tags can help you organize, track costs for, and control access to your
     * resources. You can add up to 50 tags for each resource.
     * </p>
     * <note>
     * <p>
     * For a list of S3 resources that support tagging, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html#manage-tags">Managing tags for Amazon S3
     * resources</a>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * For vector buckets and vector indexes, you must have the <code>s3vectors:TagResource</code> permission to use
     * this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, ConflictException, AwsServiceException, SdkClientException,
            S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies one or more user-defined tags to an Amazon S3 Vectors resource or updates existing tags. Each tag is a
     * label consisting of a key and value pair. Tags can help you organize, track costs for, and control access to your
     * resources. You can add up to 50 tags for each resource.
     * </p>
     * <note>
     * <p>
     * For a list of S3 resources that support tagging, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html#manage-tags">Managing tags for Amazon S3
     * resources</a>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * For vector buckets and vector indexes, you must have the <code>s3vectors:TagResource</code> permission to use
     * this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, ConflictException, AwsServiceException, SdkClientException,
            S3VectorsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified user-defined tags from an Amazon S3 Vectors resource. You can pass one or more tag keys.
     * </p>
     * <note>
     * <p>
     * For a list of S3 resources that support tagging, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html#manage-tags">Managing tags for Amazon S3
     * resources</a>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * For vector buckets and vector indexes, you must have the <code>s3vectors:UntagResource</code> permission to use
     * this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ServiceUnavailableException, TooManyRequestsException, InternalServerException, AccessDeniedException,
            RequestTimeoutException, NotFoundException, ConflictException, AwsServiceException, SdkClientException,
            S3VectorsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified user-defined tags from an Amazon S3 Vectors resource. You can pass one or more tag keys.
     * </p>
     * <note>
     * <p>
     * For a list of S3 resources that support tagging, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html#manage-tags">Managing tags for Amazon S3
     * resources</a>.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * For vector buckets and vector indexes, you must have the <code>s3vectors:UntagResource</code> permission to use
     * this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The requested action isn't valid.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Wait briefly and retry your request. If it continues to fail, increase your
     *         waiting time between retries.
     * @throws TooManyRequestsException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         The request failed due to an internal server error.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws RequestTimeoutException
     *         The request timed out. Retry your request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource can't be found.
     * @throws ConflictException
     *         The request failed because a vector bucket name or a vector index name already exists. Vector bucket
     *         names must be unique within your Amazon Web Services account for each Amazon Web Services Region. Vector
     *         index names must be unique within your vector bucket. Choose a different vector bucket name or vector
     *         index name, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3VectorsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3VectorsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ServiceUnavailableException, TooManyRequestsException, InternalServerException,
            AccessDeniedException, RequestTimeoutException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, S3VectorsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link S3VectorsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static S3VectorsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link S3VectorsClient}.
     */
    static S3VectorsClientBuilder builder() {
        return new DefaultS3VectorsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default S3VectorsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
