/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3vectors.S3VectorsAsyncClient;
import software.amazon.awssdk.services.s3vectors.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse;
import software.amazon.awssdk.services.s3vectors.model.VectorBucketSummary;

public class ListVectorBucketsPublisher
implements SdkPublisher<ListVectorBucketsResponse> {
    private final S3VectorsAsyncClient client;
    private final ListVectorBucketsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVectorBucketsPublisher(S3VectorsAsyncClient client, ListVectorBucketsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVectorBucketsPublisher(S3VectorsAsyncClient client, ListVectorBucketsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVectorBucketsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVectorBucketsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VectorBucketSummary> vectorBuckets() {
        Function<ListVectorBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vectorBuckets() != null) {
                return response.vectorBuckets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVectorBucketsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVectorBucketsResponseFetcher
    implements AsyncPageFetcher<ListVectorBucketsResponse> {
        private ListVectorBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListVectorBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVectorBucketsResponse> nextPage(ListVectorBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListVectorBucketsPublisher.this.client.listVectorBuckets(ListVectorBucketsPublisher.this.firstRequest);
            }
            return ListVectorBucketsPublisher.this.client.listVectorBuckets((ListVectorBucketsRequest)((Object)ListVectorBucketsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

