/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <note>
 * <p>
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 * </p>
 * </note>
 * <p>
 * Summary information about a vector index.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexSummary implements SdkPojo, Serializable, ToCopyableBuilder<IndexSummary.Builder, IndexSummary> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketName").getter(getter(IndexSummary::vectorBucketName))
            .setter(setter(Builder::vectorBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(IndexSummary::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexArn").getter(getter(IndexSummary::indexArn)).setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(IndexSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD,
            INDEX_NAME_FIELD, INDEX_ARN_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vectorBucketName;

    private final String indexName;

    private final String indexArn;

    private final Instant creationTime;

    private IndexSummary(BuilderImpl builder) {
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the vector bucket that contains the vector index.
     * </p>
     * 
     * @return The name of the vector bucket that contains the vector index.
     */
    public final String vectorBucketName() {
        return vectorBucketName;
    }

    /**
     * <p>
     * The name of the vector index.
     * </p>
     * 
     * @return The name of the vector index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vector index.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vector index.
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * <p>
     * Date and time when the vector index was created.
     * </p>
     * 
     * @return Date and time when the vector index was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexSummary)) {
            return false;
        }
        IndexSummary other = (IndexSummary) obj;
        return Objects.equals(vectorBucketName(), other.vectorBucketName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(indexArn(), other.indexArn()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexSummary").add("VectorBucketName", vectorBucketName()).add("IndexName", indexName())
                .add("IndexArn", indexArn()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorBucketName":
            return Optional.ofNullable(clazz.cast(vectorBucketName()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "indexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexSummary, T> g) {
        return obj -> g.apply((IndexSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexSummary> {
        /**
         * <p>
         * The name of the vector bucket that contains the vector index.
         * </p>
         * 
         * @param vectorBucketName
         *        The name of the vector bucket that contains the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketName(String vectorBucketName);

        /**
         * <p>
         * The name of the vector index.
         * </p>
         * 
         * @param indexName
         *        The name of the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vector index.
         * </p>
         * 
         * @param indexArn
         *        The Amazon Resource Name (ARN) of the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * Date and time when the vector index was created.
         * </p>
         * 
         * @param creationTime
         *        Date and time when the vector index was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String vectorBucketName;

        private String indexName;

        private String indexArn;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexSummary model) {
            vectorBucketName(model.vectorBucketName);
            indexName(model.indexName);
            indexArn(model.indexArn);
            creationTime(model.creationTime);
        }

        public final String getVectorBucketName() {
            return vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public IndexSummary build() {
            return new IndexSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
