/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.DeleteVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.GetIndexRequest;
import software.amazon.awssdk.services.s3vectors.model.GetIndexResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorBucketResponse;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.GetVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyResponse;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.PutVectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsRequest;
import software.amazon.awssdk.services.s3vectors.model.QueryVectorsResponse;
import software.amazon.awssdk.services.s3vectors.paginators.ListIndexesPublisher;
import software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsPublisher;
import software.amazon.awssdk.services.s3vectors.paginators.ListVectorsPublisher;

/**
 * Service client for accessing Amazon S3 Vectors asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon S3 vector buckets are a bucket type to store and search vectors with sub-second search times. They are
 * designed to provide dedicated API operations for you to interact with vectors to do similarity search. Within a
 * vector bucket, you use a vector index to organize and logically group your vector data. When you make a write or read
 * request, you direct it to a single vector index. You store your vector data as vectors. A vector contains a key (a
 * name that you assign), a multi-dimensional vector, and, optionally, metadata that describes a vector. The key
 * uniquely identifies the vector in a vector index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface S3VectorsAsyncClient extends AwsClient {
    String SERVICE_NAME = "s3vectors";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "s3vectors";

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Creates a vector index within a vector bucket. To specify the vector bucket, you must use either the vector
     * bucket name or the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:CreateIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param createIndexRequest
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ConflictException The request failed because a vector bucket name or a vector index name already
     *         exists. Vector bucket names must be unique within your Amazon Web Services account for each Amazon Web
     *         Services Region. Vector index names must be unique within your vector bucket. Choose a different vector
     *         bucket name or vector index name, and try again.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Creates a vector index within a vector bucket. To specify the vector bucket, you must use either the vector
     * bucket name or the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:CreateIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.CreateIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ConflictException The request failed because a vector bucket name or a vector index name already
     *         exists. Vector bucket names must be unique within your Amazon Web Services account for each Amazon Web
     *         Services Region. Vector index names must be unique within your vector bucket. Choose a different vector
     *         bucket name or vector index name, and try again.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest) {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Creates a vector bucket in the Amazon Web Services Region that you want your bucket to be in.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:CreateVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param createVectorBucketRequest
     * @return A Java Future containing the result of the CreateVectorBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ConflictException The request failed because a vector bucket name or a vector index name already
     *         exists. Vector bucket names must be unique within your Amazon Web Services account for each Amazon Web
     *         Services Region. Vector index names must be unique within your vector bucket. Choose a different vector
     *         bucket name or vector index name, and try again.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.CreateVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/CreateVectorBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVectorBucketResponse> createVectorBucket(CreateVectorBucketRequest createVectorBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Creates a vector bucket in the Amazon Web Services Region that you want your bucket to be in.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:CreateVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVectorBucketRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVectorBucketRequest#builder()}
     * </p>
     *
     * @param createVectorBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.CreateVectorBucketRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVectorBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ConflictException The request failed because a vector bucket name or a vector index name already
     *         exists. Vector bucket names must be unique within your Amazon Web Services account for each Amazon Web
     *         Services Region. Vector index names must be unique within your vector bucket. Choose a different vector
     *         bucket name or vector index name, and try again.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.CreateVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/CreateVectorBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVectorBucketResponse> createVectorBucket(
            Consumer<CreateVectorBucketRequest.Builder> createVectorBucketRequest) {
        return createVectorBucket(CreateVectorBucketRequest.builder().applyMutation(createVectorBucketRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Deletes a vector index. To specify the vector index, you can either use both the vector bucket name and vector
     * index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param deleteIndexRequest
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIndexResponse> deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Deletes a vector index. To specify the vector index, you can either use both the vector bucket name and vector
     * index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIndexRequest#builder()}
     * </p>
     *
     * @param deleteIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.DeleteIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIndexResponse> deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest) {
        return deleteIndex(DeleteIndexRequest.builder().applyMutation(deleteIndexRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Deletes a vector bucket. All vector indexes in the vector bucket must be deleted before the vector bucket can be
     * deleted. To perform this operation, you must use either the vector bucket name or the vector bucket Amazon
     * Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param deleteVectorBucketRequest
     * @return A Java Future containing the result of the DeleteVectorBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ConflictException The request failed because a vector bucket name or a vector index name already
     *         exists. Vector bucket names must be unique within your Amazon Web Services account for each Amazon Web
     *         Services Region. Vector index names must be unique within your vector bucket. Choose a different vector
     *         bucket name or vector index name, and try again.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.DeleteVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectorBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVectorBucketResponse> deleteVectorBucket(DeleteVectorBucketRequest deleteVectorBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Deletes a vector bucket. All vector indexes in the vector bucket must be deleted before the vector bucket can be
     * deleted. To perform this operation, you must use either the vector bucket name or the vector bucket Amazon
     * Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVectorBucketRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVectorBucketRequest#builder()}
     * </p>
     *
     * @param deleteVectorBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVectorBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ConflictException The request failed because a vector bucket name or a vector index name already
     *         exists. Vector bucket names must be unique within your Amazon Web Services account for each Amazon Web
     *         Services Region. Vector index names must be unique within your vector bucket. Choose a different vector
     *         bucket name or vector index name, and try again.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.DeleteVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectorBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVectorBucketResponse> deleteVectorBucket(
            Consumer<DeleteVectorBucketRequest.Builder> deleteVectorBucketRequest) {
        return deleteVectorBucket(DeleteVectorBucketRequest.builder().applyMutation(deleteVectorBucketRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Deletes a vector bucket policy. To specify the bucket, you must use either the vector bucket name or the vector
     * bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param deleteVectorBucketPolicyRequest
     * @return A Java Future containing the result of the DeleteVectorBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.DeleteVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVectorBucketPolicyResponse> deleteVectorBucketPolicy(
            DeleteVectorBucketPolicyRequest deleteVectorBucketPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Deletes a vector bucket policy. To specify the bucket, you must use either the vector bucket name or the vector
     * bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVectorBucketPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVectorBucketPolicyRequest#builder()}
     * </p>
     *
     * @param deleteVectorBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.DeleteVectorBucketPolicyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteVectorBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.DeleteVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVectorBucketPolicyResponse> deleteVectorBucketPolicy(
            Consumer<DeleteVectorBucketPolicyRequest.Builder> deleteVectorBucketPolicyRequest) {
        return deleteVectorBucketPolicy(DeleteVectorBucketPolicyRequest.builder().applyMutation(deleteVectorBucketPolicyRequest)
                .build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Deletes one or more vectors in a vector index. To specify the vector index, you can either use both the vector
     * bucket name and vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param deleteVectorsRequest
     * @return A Java Future containing the result of the DeleteVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>KmsInvalidKeyUsageException The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>KmsInvalidStateException The key state of the KMS key isn't compatible with the operation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>KmsNotFoundException The KMS key can't be found.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>KmsDisabledException The specified Amazon Web Services KMS key isn't enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.DeleteVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVectorsResponse> deleteVectors(DeleteVectorsRequest deleteVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Deletes one or more vectors in a vector index. To specify the vector index, you can either use both the vector
     * bucket name and vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:DeleteVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVectorsRequest#builder()}
     * </p>
     *
     * @param deleteVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.DeleteVectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>KmsInvalidKeyUsageException The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>KmsInvalidStateException The key state of the KMS key isn't compatible with the operation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>KmsNotFoundException The KMS key can't be found.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>KmsDisabledException The specified Amazon Web Services KMS key isn't enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.DeleteVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/DeleteVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVectorsResponse> deleteVectors(Consumer<DeleteVectorsRequest.Builder> deleteVectorsRequest) {
        return deleteVectors(DeleteVectorsRequest.builder().applyMutation(deleteVectorsRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns vector index attributes. To specify the vector index, you can either use both the vector bucket name and
     * the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param getIndexRequest
     * @return A Java Future containing the result of the GetIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIndexResponse> getIndex(GetIndexRequest getIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns vector index attributes. To specify the vector index, you can either use both the vector bucket name and
     * the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetIndex</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIndexRequest.Builder} avoiding the need to
     * create one manually via {@link GetIndexRequest#builder()}
     * </p>
     *
     * @param getIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.GetIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIndexResponse> getIndex(Consumer<GetIndexRequest.Builder> getIndexRequest) {
        return getIndex(GetIndexRequest.builder().applyMutation(getIndexRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns vector bucket attributes. To specify the bucket, you must use either the vector bucket name or the vector
     * bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param getVectorBucketRequest
     * @return A Java Future containing the result of the GetVectorBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.GetVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectorBucket" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVectorBucketResponse> getVectorBucket(GetVectorBucketRequest getVectorBucketRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns vector bucket attributes. To specify the bucket, you must use either the vector bucket name or the vector
     * bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectorBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVectorBucketRequest.Builder} avoiding the need
     * to create one manually via {@link GetVectorBucketRequest#builder()}
     * </p>
     *
     * @param getVectorBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.GetVectorBucketRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVectorBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.GetVectorBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectorBucket" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVectorBucketResponse> getVectorBucket(
            Consumer<GetVectorBucketRequest.Builder> getVectorBucketRequest) {
        return getVectorBucket(GetVectorBucketRequest.builder().applyMutation(getVectorBucketRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Gets details about a vector bucket policy. To specify the bucket, you must use either the vector bucket name or
     * the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param getVectorBucketPolicyRequest
     * @return A Java Future containing the result of the GetVectorBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.GetVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVectorBucketPolicyResponse> getVectorBucketPolicy(
            GetVectorBucketPolicyRequest getVectorBucketPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Gets details about a vector bucket policy. To specify the bucket, you must use either the vector bucket name or
     * the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVectorBucketPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetVectorBucketPolicyRequest#builder()}
     * </p>
     *
     * @param getVectorBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.GetVectorBucketPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVectorBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.GetVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVectorBucketPolicyResponse> getVectorBucketPolicy(
            Consumer<GetVectorBucketPolicyRequest.Builder> getVectorBucketPolicyRequest) {
        return getVectorBucketPolicy(GetVectorBucketPolicyRequest.builder().applyMutation(getVectorBucketPolicyRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns vector attributes. To specify the vector index, you can either use both the vector bucket name and the
     * vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param getVectorsRequest
     * @return A Java Future containing the result of the GetVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>KmsInvalidKeyUsageException The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>KmsInvalidStateException The key state of the KMS key isn't compatible with the operation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>KmsNotFoundException The KMS key can't be found.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>KmsDisabledException The specified Amazon Web Services KMS key isn't enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.GetVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVectorsResponse> getVectors(GetVectorsRequest getVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns vector attributes. To specify the vector index, you can either use both the vector bucket name and the
     * vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:GetVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetVectorsRequest#builder()}
     * </p>
     *
     * @param getVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.GetVectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>KmsInvalidKeyUsageException The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>KmsInvalidStateException The key state of the KMS key isn't compatible with the operation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>KmsNotFoundException The KMS key can't be found.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>KmsDisabledException The specified Amazon Web Services KMS key isn't enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.GetVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/GetVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVectorsResponse> getVectors(Consumer<GetVectorsRequest.Builder> getVectorsRequest) {
        return getVectors(GetVectorsRequest.builder().applyMutation(getVectorsRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all the vector indexes within the specified vector bucket. To specify the bucket, you must use
     * either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListIndexes</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param listIndexesRequest
     * @return A Java Future containing the result of the ListIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIndexesResponse> listIndexes(ListIndexesRequest listIndexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all the vector indexes within the specified vector bucket. To specify the bucket, you must use
     * either the vector bucket name or the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListIndexes</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexesRequest#builder()}
     * </p>
     *
     * @param listIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIndexesResponse> listIndexes(Consumer<ListIndexesRequest.Builder> listIndexesRequest) {
        return listIndexes(ListIndexesRequest.builder().applyMutation(listIndexesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listIndexes(software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListIndexesPublisher publisher = client.listIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListIndexesPublisher publisher = client.listIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexes(software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest)} operation.</b>
     * </p>
     *
     * @param listIndexesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndexesPublisher listIndexesPaginator(ListIndexesRequest listIndexesRequest) {
        return new ListIndexesPublisher(this, listIndexesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listIndexes(software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListIndexesPublisher publisher = client.listIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListIndexesPublisher publisher = client.listIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndexes(software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndexesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndexesRequest#builder()}
     * </p>
     *
     * @param listIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndexesPublisher listIndexesPaginator(Consumer<ListIndexesRequest.Builder> listIndexesRequest) {
        return listIndexesPaginator(ListIndexesRequest.builder().applyMutation(listIndexesRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all the vector buckets that are owned by the authenticated sender of the request.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListVectorBuckets</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param listVectorBucketsRequest
     * @return A Java Future containing the result of the ListVectorBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListVectorBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectorBuckets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVectorBucketsResponse> listVectorBuckets(ListVectorBucketsRequest listVectorBucketsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all the vector buckets that are owned by the authenticated sender of the request.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListVectorBuckets</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVectorBucketsRequest#builder()}
     * </p>
     *
     * @param listVectorBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVectorBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListVectorBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectorBuckets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVectorBucketsResponse> listVectorBuckets(
            Consumer<ListVectorBucketsRequest.Builder> listVectorBucketsRequest) {
        return listVectorBuckets(ListVectorBucketsRequest.builder().applyMutation(listVectorBucketsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVectorBuckets(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsPublisher publisher = client.listVectorBucketsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsPublisher publisher = client.listVectorBucketsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectorBuckets(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVectorBucketsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListVectorBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectorBuckets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVectorBucketsPublisher listVectorBucketsPaginator(ListVectorBucketsRequest listVectorBucketsRequest) {
        return new ListVectorBucketsPublisher(this, listVectorBucketsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVectorBuckets(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsPublisher publisher = client.listVectorBucketsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorBucketsPublisher publisher = client.listVectorBucketsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectorBuckets(software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVectorBucketsRequest#builder()}
     * </p>
     *
     * @param listVectorBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListVectorBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectorBuckets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVectorBucketsPublisher listVectorBucketsPaginator(
            Consumer<ListVectorBucketsRequest.Builder> listVectorBucketsRequest) {
        return listVectorBucketsPaginator(ListVectorBucketsRequest.builder().applyMutation(listVectorBucketsRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * List vectors in the specified vector index. To specify the vector index, you can either use both the vector
     * bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <p>
     * <code>ListVectors</code> operations proceed sequentially; however, for faster performance on a large number of
     * vectors in a vector index, applications can request a parallel <code>ListVectors</code> operation by providing
     * the <code>segmentCount</code> and <code>segmentIndex</code> parameters.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListVectors</code> permission to use this operation. Additional permissions are
     * required based on the request parameters you specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * With only <code>s3vectors:ListVectors</code> permission, you can list vector keys when <code>returnData</code>
     * and <code>returnMetadata</code> are both set to false or not specified..
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>returnData</code> or <code>returnMetadata</code> to true, you must have both
     * <code>s3vectors:ListVectors</code> and <code>s3vectors:GetVectors</code> permissions. The request fails with a
     * <code>403 Forbidden</code> error if you request vector data or metadata without the
     * <code>s3vectors:GetVectors</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * </p>
     *
     * @param listVectorsRequest
     * @return A Java Future containing the result of the ListVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVectorsResponse> listVectors(ListVectorsRequest listVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * List vectors in the specified vector index. To specify the vector index, you can either use both the vector
     * bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <p>
     * <code>ListVectors</code> operations proceed sequentially; however, for faster performance on a large number of
     * vectors in a vector index, applications can request a parallel <code>ListVectors</code> operation by providing
     * the <code>segmentCount</code> and <code>segmentIndex</code> parameters.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:ListVectors</code> permission to use this operation. Additional permissions are
     * required based on the request parameters you specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * With only <code>s3vectors:ListVectors</code> permission, you can list vector keys when <code>returnData</code>
     * and <code>returnMetadata</code> are both set to false or not specified..
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>returnData</code> or <code>returnMetadata</code> to true, you must have both
     * <code>s3vectors:ListVectors</code> and <code>s3vectors:GetVectors</code> permissions. The request fails with a
     * <code>403 Forbidden</code> error if you request vector data or metadata without the
     * <code>s3vectors:GetVectors</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVectorsRequest#builder()}
     * </p>
     *
     * @param listVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVectorsResponse> listVectors(Consumer<ListVectorsRequest.Builder> listVectorsRequest) {
        return listVectors(ListVectorsRequest.builder().applyMutation(listVectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listVectors(software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorsPublisher publisher = client.listVectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorsPublisher publisher = client.listVectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectors(software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest)} operation.</b>
     * </p>
     *
     * @param listVectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVectorsPublisher listVectorsPaginator(ListVectorsRequest listVectorsRequest) {
        return new ListVectorsPublisher(this, listVectorsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listVectors(software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorsPublisher publisher = client.listVectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3vectors.paginators.ListVectorsPublisher publisher = client.listVectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.s3vectors.model.ListVectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVectors(software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListVectorsRequest#builder()}
     * </p>
     *
     * @param listVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.ListVectorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.ListVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/ListVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVectorsPublisher listVectorsPaginator(Consumer<ListVectorsRequest.Builder> listVectorsRequest) {
        return listVectorsPaginator(ListVectorsRequest.builder().applyMutation(listVectorsRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Creates a bucket policy for a vector bucket. To specify the bucket, you must use either the vector bucket name or
     * the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:PutVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param putVectorBucketPolicyRequest
     * @return A Java Future containing the result of the PutVectorBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.PutVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/PutVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVectorBucketPolicyResponse> putVectorBucketPolicy(
            PutVectorBucketPolicyRequest putVectorBucketPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Creates a bucket policy for a vector bucket. To specify the bucket, you must use either the vector bucket name or
     * the vector bucket Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:PutVectorBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVectorBucketPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutVectorBucketPolicyRequest#builder()}
     * </p>
     *
     * @param putVectorBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.PutVectorBucketPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutVectorBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.PutVectorBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/PutVectorBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVectorBucketPolicyResponse> putVectorBucketPolicy(
            Consumer<PutVectorBucketPolicyRequest.Builder> putVectorBucketPolicyRequest) {
        return putVectorBucketPolicy(PutVectorBucketPolicyRequest.builder().applyMutation(putVectorBucketPolicyRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Adds one or more vectors to a vector index. To specify the vector index, you can either use both the vector
     * bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information about limits, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations and
     * restrictions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * When inserting vector data into your vector index, you must provide the vector data as <code>float32</code>
     * (32-bit floating point) values. If you pass higher-precision values to an Amazon Web Services SDK, S3 Vectors
     * converts the values to 32-bit floating point before storing them, and <code>GetVectors</code>,
     * <code>ListVectors</code>, and <code>QueryVectors</code> operations return the float32 values. Different Amazon
     * Web Services SDKs may have different default numeric types, so ensure your vectors are properly formatted as
     * <code>float32</code> values regardless of which SDK you're using. For example, in Python, use
     * <code>numpy.float32</code> or explicitly cast your values.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:PutVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p>
     *
     * @param putVectorsRequest
     * @return A Java Future containing the result of the PutVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>KmsInvalidKeyUsageException The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>KmsInvalidStateException The key state of the KMS key isn't compatible with the operation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>KmsNotFoundException The KMS key can't be found.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>KmsDisabledException The specified Amazon Web Services KMS key isn't enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.PutVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/PutVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutVectorsResponse> putVectors(PutVectorsRequest putVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Adds one or more vectors to a vector index. To specify the vector index, you can either use both the vector
     * bucket name and the vector index name, or use the vector index Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information about limits, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations and
     * restrictions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * When inserting vector data into your vector index, you must provide the vector data as <code>float32</code>
     * (32-bit floating point) values. If you pass higher-precision values to an Amazon Web Services SDK, S3 Vectors
     * converts the values to 32-bit floating point before storing them, and <code>GetVectors</code>,
     * <code>ListVectors</code>, and <code>QueryVectors</code> operations return the float32 values. Different Amazon
     * Web Services SDKs may have different default numeric types, so ensure your vectors are properly formatted as
     * <code>float32</code> values regardless of which SDK you're using. For example, in Python, use
     * <code>numpy.float32</code> or explicitly cast your values.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:PutVectors</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link PutVectorsRequest#builder()}
     * </p>
     *
     * @param putVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.PutVectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>KmsInvalidKeyUsageException The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>KmsInvalidStateException The key state of the KMS key isn't compatible with the operation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>KmsNotFoundException The KMS key can't be found.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>KmsDisabledException The specified Amazon Web Services KMS key isn't enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.PutVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/PutVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutVectorsResponse> putVectors(Consumer<PutVectorsRequest.Builder> putVectorsRequest) {
        return putVectors(PutVectorsRequest.builder().applyMutation(putVectorsRequest).build());
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Performs an approximate nearest neighbor search query in a vector index using a query vector. By default, it
     * returns the keys of approximate nearest neighbors. You can optionally include the computed distance (between the
     * query vector and each vector in the response), the vector data, and metadata of each vector in the response.
     * </p>
     * <p>
     * To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the
     * vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:QueryVectors</code> permission to use this operation. Additional permissions
     * are required based on the request parameters you specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * With only <code>s3vectors:QueryVectors</code> permission, you can retrieve vector keys of approximate nearest
     * neighbors and computed distances between these vectors. This permission is sufficient only when you don't set any
     * metadata filters and don't request vector data or metadata (by keeping the <code>returnMetadata</code> parameter
     * set to <code>false</code> or not specified).
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a metadata filter or set <code>returnMetadata</code> to true, you must have both
     * <code>s3vectors:QueryVectors</code> and <code>s3vectors:GetVectors</code> permissions. The request fails with a
     * <code>403 Forbidden error</code> if you request metadata filtering, vector data, or metadata without the
     * <code>s3vectors:GetVectors</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * </p>
     *
     * @param queryVectorsRequest
     * @return A Java Future containing the result of the QueryVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>KmsInvalidKeyUsageException The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>KmsInvalidStateException The key state of the KMS key isn't compatible with the operation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>KmsNotFoundException The KMS key can't be found.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>KmsDisabledException The specified Amazon Web Services KMS key isn't enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.QueryVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/QueryVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<QueryVectorsResponse> queryVectors(QueryVectorsRequest queryVectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <note>
     * <p>
     * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
     * </p>
     * </note>
     * <p>
     * Performs an approximate nearest neighbor search query in a vector index using a query vector. By default, it
     * returns the keys of approximate nearest neighbors. You can optionally include the computed distance (between the
     * query vector and each vector in the response), the vector data, and metadata of each vector in the response.
     * </p>
     * <p>
     * To specify the vector index, you can either use both the vector bucket name and the vector index name, or use the
     * vector index Amazon Resource Name (ARN).
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3vectors:QueryVectors</code> permission to use this operation. Additional permissions
     * are required based on the request parameters you specify:
     * </p>
     * <ul>
     * <li>
     * <p>
     * With only <code>s3vectors:QueryVectors</code> permission, you can retrieve vector keys of approximate nearest
     * neighbors and computed distances between these vectors. This permission is sufficient only when you don't set any
     * metadata filters and don't request vector data or metadata (by keeping the <code>returnMetadata</code> parameter
     * set to <code>false</code> or not specified).
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a metadata filter or set <code>returnMetadata</code> to true, you must have both
     * <code>s3vectors:QueryVectors</code> and <code>s3vectors:GetVectors</code> permissions. The request fails with a
     * <code>403 Forbidden error</code> if you request metadata filtering, vector data, or metadata without the
     * <code>s3vectors:GetVectors</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * </p><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryVectorsRequest.Builder} avoiding the need to
     * create one manually via {@link QueryVectorsRequest#builder()}
     * </p>
     *
     * @param queryVectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3vectors.model.QueryVectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the QueryVectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested action isn't valid.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Wait briefly and retry your request. If it
     *         continues to fail, increase your waiting time between retries.</li>
     *         <li>TooManyRequestsException The request was denied due to request throttling.</li>
     *         <li>KmsInvalidKeyUsageException The request was rejected for one of the following reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The <code>KeyUsage</code> value of the KMS key is incompatible with the API operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The encryption algorithm or signing algorithm specified for the operation is incompatible with the type
     *         of key material in the KMS key (<code>KeySpec</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >InvalidKeyUsageException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>InternalServerException The request failed due to an internal server error.</li>
     *         <li>KmsInvalidStateException The key state of the KMS key isn't compatible with the operation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html#API_Encrypt_Errors"
     *         >KMSInvalidStateException</a> in the <i>Amazon Web Services Key Management Service API Reference</i>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>KmsNotFoundException The KMS key can't be found.</li>
     *         <li>NotFoundException The request was rejected because the specified resource can't be found.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds a service quota.</li>
     *         <li>KmsDisabledException The specified Amazon Web Services KMS key isn't enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3VectorsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3VectorsAsyncClient.QueryVectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3vectors-2025-07-15/QueryVectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<QueryVectorsResponse> queryVectors(Consumer<QueryVectorsRequest.Builder> queryVectorsRequest) {
        return queryVectors(QueryVectorsRequest.builder().applyMutation(queryVectorsRequest).build());
    }

    @Override
    default S3VectorsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link S3VectorsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static S3VectorsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link S3VectorsAsyncClient}.
     */
    static S3VectorsAsyncClientBuilder builder() {
        return new DefaultS3VectorsAsyncClientBuilder();
    }
}
