/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3vectors.model.Float32VectorDataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VectorData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VectorData> {
    private static final SdkField<List<Float>> FLOAT32_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("float32").getter(VectorData.getter(VectorData::float32)).setter(VectorData.setter(Builder::float32)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("float32").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.FLOAT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOAT32_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VectorData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Float> float32;
    private final Type type;

    private VectorData(BuilderImpl builder) {
        this.float32 = builder.float32;
        this.type = builder.type;
    }

    public final boolean hasFloat32() {
        return this.float32 != null && !(this.float32 instanceof SdkAutoConstructList);
    }

    public final List<Float> float32() {
        return this.float32;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFloat32() ? this.float32() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorData)) {
            return false;
        }
        VectorData other = (VectorData)obj;
        return this.hasFloat32() == other.hasFloat32() && Objects.equals(this.float32(), other.float32());
    }

    public final String toString() {
        return ToString.builder((String)"VectorData").add("Float32", this.hasFloat32() ? this.float32() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "float32": {
                return Optional.ofNullable(clazz.cast(this.float32()));
            }
        }
        return Optional.empty();
    }

    public static VectorData fromFloat32(List<Float> float32) {
        return (VectorData)VectorData.builder().float32(float32).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Float>>> map = new HashMap<String, SdkField<List<Float>>>();
        map.put("float32", FLOAT32_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VectorData, T> g) {
        return obj -> g.apply((VectorData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FLOAT32,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<Float> float32 = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VectorData model) {
            this.float32(model.float32);
        }

        public final Collection<Float> getFloat32() {
            if (this.float32 instanceof SdkAutoConstructList) {
                return null;
            }
            return this.float32;
        }

        public final void setFloat32(Collection<Float> float32) {
            List<Float> oldValue = this.float32;
            this.float32 = Float32VectorDataCopier.copy(float32);
            this.handleUnionValueChange(Type.FLOAT32, oldValue, this.float32);
        }

        @Override
        public final Builder float32(Collection<Float> float32) {
            List<Float> oldValue = this.float32;
            this.float32 = Float32VectorDataCopier.copy(float32);
            this.handleUnionValueChange(Type.FLOAT32, oldValue, this.float32);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder float32(Float ... float32) {
            this.float32(Arrays.asList(float32));
            return this;
        }

        public VectorData build() {
            return new VectorData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VectorData> {
        public Builder float32(Collection<Float> var1);

        public Builder float32(Float ... var1);
    }
}

