/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.services.s3tables.model.TableMaintenanceJobStatusCopier;
import software.amazon.awssdk.services.s3tables.model.TableMaintenanceJobStatusValue;
import software.amazon.awssdk.services.s3tables.model.TableMaintenanceJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableMaintenanceJobStatusResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, GetTableMaintenanceJobStatusResponse> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableARN").getter(GetTableMaintenanceJobStatusResponse.getter(GetTableMaintenanceJobStatusResponse::tableARN)).setter(GetTableMaintenanceJobStatusResponse.setter(Builder::tableARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()}).build();
    private static final SdkField<Map<String, TableMaintenanceJobStatusValue>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("status").getter(GetTableMaintenanceJobStatusResponse.getter(GetTableMaintenanceJobStatusResponse::statusAsStrings)).setter(GetTableMaintenanceJobStatusResponse.setter(Builder::statusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableMaintenanceJobStatusValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTableMaintenanceJobStatusResponse.memberNameToFieldInitializer();
    private final String tableARN;
    private final Map<String, TableMaintenanceJobStatusValue> status;

    private GetTableMaintenanceJobStatusResponse(BuilderImpl builder) {
        super(builder);
        this.tableARN = builder.tableARN;
        this.status = builder.status;
    }

    public final String tableARN() {
        return this.tableARN;
    }

    public final Map<TableMaintenanceJobType, TableMaintenanceJobStatusValue> status() {
        return TableMaintenanceJobStatusCopier.copyStringToEnum(this.status);
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructMap);
    }

    public final Map<String, TableMaintenanceJobStatusValue> statusAsStrings() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.statusAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableMaintenanceJobStatusResponse)) {
            return false;
        }
        GetTableMaintenanceJobStatusResponse other = (GetTableMaintenanceJobStatusResponse)((Object)obj);
        return Objects.equals(this.tableARN(), other.tableARN()) && this.hasStatus() == other.hasStatus() && Objects.equals(this.statusAsStrings(), other.statusAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableMaintenanceJobStatusResponse").add("TableARN", (Object)this.tableARN()).add("Status", this.hasStatus() ? this.statusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableARN": {
                return Optional.ofNullable(clazz.cast(this.tableARN()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableARN", TABLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableMaintenanceJobStatusResponse, T> g) {
        return obj -> g.apply((GetTableMaintenanceJobStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String tableARN;
        private Map<String, TableMaintenanceJobStatusValue> status = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableMaintenanceJobStatusResponse model) {
            super(model);
            this.tableARN(model.tableARN);
            this.statusWithStrings(model.status);
        }

        public final String getTableARN() {
            return this.tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final Map<String, TableMaintenanceJobStatusValue.Builder> getStatus() {
            Map<String, TableMaintenanceJobStatusValue.Builder> result = TableMaintenanceJobStatusCopier.copyToBuilder(this.status);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setStatus(Map<String, TableMaintenanceJobStatusValue.BuilderImpl> status) {
            this.status = TableMaintenanceJobStatusCopier.copyFromBuilder(status);
        }

        @Override
        public final Builder statusWithStrings(Map<String, TableMaintenanceJobStatusValue> status) {
            this.status = TableMaintenanceJobStatusCopier.copy(status);
            return this;
        }

        @Override
        public final Builder status(Map<TableMaintenanceJobType, TableMaintenanceJobStatusValue> status) {
            this.status = TableMaintenanceJobStatusCopier.copyEnumToString(status);
            return this;
        }

        @Override
        public GetTableMaintenanceJobStatusResponse build() {
            return new GetTableMaintenanceJobStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableMaintenanceJobStatusResponse> {
        public Builder tableARN(String var1);

        public Builder statusWithStrings(Map<String, TableMaintenanceJobStatusValue> var1);

        public Builder status(Map<TableMaintenanceJobType, TableMaintenanceJobStatusValue> var1);
    }
}

