/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TableType {
    CUSTOMER("customer"),
    AWS("aws"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TableType> VALUE_MAP;
    private final String value;

    private TableType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TableType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TableType> knownValues() {
        EnumSet<TableType> knownValues = EnumSet.allOf(TableType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TableType.class, TableType::toString);
    }
}

