/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.s3outposts.DefaultS3OutpostsClientBuilder;
import software.amazon.awssdk.services.s3outposts.S3OutpostsClientBuilder;
import software.amazon.awssdk.services.s3outposts.model.AccessDeniedException;
import software.amazon.awssdk.services.s3outposts.model.ConflictException;
import software.amazon.awssdk.services.s3outposts.model.CreateEndpointRequest;
import software.amazon.awssdk.services.s3outposts.model.CreateEndpointResponse;
import software.amazon.awssdk.services.s3outposts.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.s3outposts.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.s3outposts.model.InternalServerException;
import software.amazon.awssdk.services.s3outposts.model.ListEndpointsRequest;
import software.amazon.awssdk.services.s3outposts.model.ListEndpointsResponse;
import software.amazon.awssdk.services.s3outposts.model.ListSharedEndpointsRequest;
import software.amazon.awssdk.services.s3outposts.model.ListSharedEndpointsResponse;
import software.amazon.awssdk.services.s3outposts.model.ResourceNotFoundException;
import software.amazon.awssdk.services.s3outposts.model.S3OutpostsException;
import software.amazon.awssdk.services.s3outposts.model.ValidationException;
import software.amazon.awssdk.services.s3outposts.paginators.ListEndpointsIterable;
import software.amazon.awssdk.services.s3outposts.paginators.ListSharedEndpointsIterable;

@SdkPublicApi
@ThreadSafe
public interface S3OutpostsClient
extends SdkClient {
    public static final String SERVICE_NAME = "s3-outposts";
    public static final String SERVICE_METADATA_ID = "s3-outposts";

    default public CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest) throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, S3OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public CreateEndpointResponse createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest) throws InternalServerException, ValidationException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, S3OutpostsException {
        return this.createEndpoint((CreateEndpointRequest)((Object)((CreateEndpointRequest.Builder)CreateEndpointRequest.builder().applyMutation(createEndpointRequest)).build()));
    }

    default public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteEndpointResponse deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest) throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        return this.deleteEndpoint((DeleteEndpointRequest)((Object)((DeleteEndpointRequest.Builder)DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest)).build()));
    }

    default public ListEndpointsResponse listEndpoints(ListEndpointsRequest listEndpointsRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListEndpointsResponse listEndpoints(Consumer<ListEndpointsRequest.Builder> listEndpointsRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        return this.listEndpoints((ListEndpointsRequest)((Object)((ListEndpointsRequest.Builder)ListEndpointsRequest.builder().applyMutation(listEndpointsRequest)).build()));
    }

    default public ListEndpointsIterable listEndpointsPaginator(ListEndpointsRequest listEndpointsRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListEndpointsIterable listEndpointsPaginator(Consumer<ListEndpointsRequest.Builder> listEndpointsRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        return this.listEndpointsPaginator((ListEndpointsRequest)((Object)((ListEndpointsRequest.Builder)ListEndpointsRequest.builder().applyMutation(listEndpointsRequest)).build()));
    }

    default public ListSharedEndpointsResponse listSharedEndpoints(ListSharedEndpointsRequest listSharedEndpointsRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListSharedEndpointsResponse listSharedEndpoints(Consumer<ListSharedEndpointsRequest.Builder> listSharedEndpointsRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        return this.listSharedEndpoints((ListSharedEndpointsRequest)((Object)((ListSharedEndpointsRequest.Builder)ListSharedEndpointsRequest.builder().applyMutation(listSharedEndpointsRequest)).build()));
    }

    default public ListSharedEndpointsIterable listSharedEndpointsPaginator(ListSharedEndpointsRequest listSharedEndpointsRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        throw new UnsupportedOperationException();
    }

    default public ListSharedEndpointsIterable listSharedEndpointsPaginator(Consumer<ListSharedEndpointsRequest.Builder> listSharedEndpointsRequest) throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, S3OutpostsException {
        return this.listSharedEndpointsPaginator((ListSharedEndpointsRequest)((Object)((ListSharedEndpointsRequest.Builder)ListSharedEndpointsRequest.builder().applyMutation(listSharedEndpointsRequest)).build()));
    }

    public static S3OutpostsClient create() {
        return (S3OutpostsClient)S3OutpostsClient.builder().build();
    }

    public static S3OutpostsClientBuilder builder() {
        return new DefaultS3OutpostsClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"s3-outposts");
    }
}

