/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3outposts.DefaultS3OutpostsBaseClientBuilder;
import software.amazon.awssdk.services.s3outposts.DefaultS3OutpostsClient;
import software.amazon.awssdk.services.s3outposts.S3OutpostsClient;
import software.amazon.awssdk.services.s3outposts.S3OutpostsClientBuilder;
import software.amazon.awssdk.services.s3outposts.S3OutpostsServiceClientConfiguration;
import software.amazon.awssdk.services.s3outposts.endpoints.S3OutpostsEndpointProvider;

@SdkInternalApi
final class DefaultS3OutpostsClientBuilder
extends DefaultS3OutpostsBaseClientBuilder<S3OutpostsClientBuilder, S3OutpostsClient>
implements S3OutpostsClientBuilder {
    DefaultS3OutpostsClientBuilder() {
    }

    @Override
    public DefaultS3OutpostsClientBuilder endpointProvider(S3OutpostsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final S3OutpostsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultS3OutpostsClientBuilder.validateClientOptions(clientConfiguration);
        S3OutpostsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultS3OutpostsClient client = new DefaultS3OutpostsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private S3OutpostsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return S3OutpostsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

