/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute;
import software.amazon.awssdk.services.s3control.model.RouteListCopier;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMultiRegionAccessPointRoutesResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, GetMultiRegionAccessPointRoutesResponse> {
    private static final SdkField<String> MRAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mrap").getter(GetMultiRegionAccessPointRoutesResponse.getter(GetMultiRegionAccessPointRoutesResponse::mrap)).setter(GetMultiRegionAccessPointRoutesResponse.setter(Builder::mrap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mrap").unmarshallLocationName("Mrap").build()}).build();
    private static final SdkField<List<MultiRegionAccessPointRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(GetMultiRegionAccessPointRoutesResponse.getter(GetMultiRegionAccessPointRoutesResponse::routes)).setter(GetMultiRegionAccessPointRoutesResponse.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").unmarshallLocationName("Routes").build(), ListTrait.builder().memberLocationName("Route").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiRegionAccessPointRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Route").unmarshallLocationName("Route").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MRAP_FIELD, ROUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMultiRegionAccessPointRoutesResponse.memberNameToFieldInitializer();
    private final String mrap;
    private final List<MultiRegionAccessPointRoute> routes;

    private GetMultiRegionAccessPointRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.mrap = builder.mrap;
        this.routes = builder.routes;
    }

    public final String mrap() {
        return this.mrap;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<MultiRegionAccessPointRoute> routes() {
        return this.routes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mrap());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMultiRegionAccessPointRoutesResponse)) {
            return false;
        }
        GetMultiRegionAccessPointRoutesResponse other = (GetMultiRegionAccessPointRoutesResponse)((Object)obj);
        return Objects.equals(this.mrap(), other.mrap()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes());
    }

    public final String toString() {
        return ToString.builder((String)"GetMultiRegionAccessPointRoutesResponse").add("Mrap", (Object)this.mrap()).add("Routes", this.hasRoutes() ? this.routes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mrap": {
                return Optional.ofNullable(clazz.cast(this.mrap()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Mrap", MRAP_FIELD);
        map.put("Routes", ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMultiRegionAccessPointRoutesResponse, T> g) {
        return obj -> g.apply((GetMultiRegionAccessPointRoutesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String mrap;
        private List<MultiRegionAccessPointRoute> routes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMultiRegionAccessPointRoutesResponse model) {
            super(model);
            this.mrap(model.mrap);
            this.routes(model.routes);
        }

        public final String getMrap() {
            return this.mrap;
        }

        public final void setMrap(String mrap) {
            this.mrap = mrap;
        }

        @Override
        public final Builder mrap(String mrap) {
            this.mrap = mrap;
            return this;
        }

        public final List<MultiRegionAccessPointRoute.Builder> getRoutes() {
            List<MultiRegionAccessPointRoute.Builder> result = RouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<MultiRegionAccessPointRoute.BuilderImpl> routes) {
            this.routes = RouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<MultiRegionAccessPointRoute> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(MultiRegionAccessPointRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<MultiRegionAccessPointRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (MultiRegionAccessPointRoute)((MultiRegionAccessPointRoute.Builder)MultiRegionAccessPointRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMultiRegionAccessPointRoutesResponse build() {
            return new GetMultiRegionAccessPointRoutesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMultiRegionAccessPointRoutesResponse> {
        public Builder mrap(String var1);

        public Builder routes(Collection<MultiRegionAccessPointRoute> var1);

        public Builder routes(MultiRegionAccessPointRoute ... var1);

        public Builder routes(Consumer<MultiRegionAccessPointRoute.Builder> ... var1);
    }
}

