/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiRegionAccessPointRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiRegionAccessPointRoute> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(MultiRegionAccessPointRoute.getter(MultiRegionAccessPointRoute::bucket)).setter(MultiRegionAccessPointRoute.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(MultiRegionAccessPointRoute.getter(MultiRegionAccessPointRoute::region)).setter(MultiRegionAccessPointRoute.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("Region").build()}).build();
    private static final SdkField<Integer> TRAFFIC_DIAL_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TrafficDialPercentage").getter(MultiRegionAccessPointRoute.getter(MultiRegionAccessPointRoute::trafficDialPercentage)).setter(MultiRegionAccessPointRoute.setter(Builder::trafficDialPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDialPercentage").unmarshallLocationName("TrafficDialPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, REGION_FIELD, TRAFFIC_DIAL_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MultiRegionAccessPointRoute.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String region;
    private final Integer trafficDialPercentage;

    private MultiRegionAccessPointRoute(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.region = builder.region;
        this.trafficDialPercentage = builder.trafficDialPercentage;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String region() {
        return this.region;
    }

    public final Integer trafficDialPercentage() {
        return this.trafficDialPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficDialPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiRegionAccessPointRoute)) {
            return false;
        }
        MultiRegionAccessPointRoute other = (MultiRegionAccessPointRoute)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.trafficDialPercentage(), other.trafficDialPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"MultiRegionAccessPointRoute").add("Bucket", (Object)this.bucket()).add("Region", (Object)this.region()).add("TrafficDialPercentage", (Object)this.trafficDialPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "TrafficDialPercentage": {
                return Optional.ofNullable(clazz.cast(this.trafficDialPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("TrafficDialPercentage", TRAFFIC_DIAL_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiRegionAccessPointRoute, T> g) {
        return obj -> g.apply((MultiRegionAccessPointRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String region;
        private Integer trafficDialPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiRegionAccessPointRoute model) {
            this.bucket(model.bucket);
            this.region(model.region);
            this.trafficDialPercentage(model.trafficDialPercentage);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Integer getTrafficDialPercentage() {
            return this.trafficDialPercentage;
        }

        public final void setTrafficDialPercentage(Integer trafficDialPercentage) {
            this.trafficDialPercentage = trafficDialPercentage;
        }

        @Override
        public final Builder trafficDialPercentage(Integer trafficDialPercentage) {
            this.trafficDialPercentage = trafficDialPercentage;
            return this;
        }

        public MultiRegionAccessPointRoute build() {
            return new MultiRegionAccessPointRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiRegionAccessPointRoute> {
        public Builder bucket(String var1);

        public Builder region(String var1);

        public Builder trafficDialPercentage(Integer var1);
    }
}

