/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsResponse;

public class ListAccessGrantsLocationsPublisher
implements SdkPublisher<ListAccessGrantsLocationsResponse> {
    private final S3ControlAsyncClient client;
    private final ListAccessGrantsLocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessGrantsLocationsPublisher(S3ControlAsyncClient client, ListAccessGrantsLocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessGrantsLocationsPublisher(S3ControlAsyncClient client, ListAccessGrantsLocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessGrantsLocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessGrantsLocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAccessGrantsLocationsResponseFetcher
    implements AsyncPageFetcher<ListAccessGrantsLocationsResponse> {
        private ListAccessGrantsLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessGrantsLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessGrantsLocationsResponse> nextPage(ListAccessGrantsLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessGrantsLocationsPublisher.this.client.listAccessGrantsLocations(ListAccessGrantsLocationsPublisher.this.firstRequest);
            }
            return ListAccessGrantsLocationsPublisher.this.client.listAccessGrantsLocations((ListAccessGrantsLocationsRequest)((Object)ListAccessGrantsLocationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

