/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStorageLensConfigurationTaggingRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, GetStorageLensConfigurationTaggingRequest> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigId").getter(GetStorageLensConfigurationTaggingRequest.getter(GetStorageLensConfigurationTaggingRequest::configId)).setter(GetStorageLensConfigurationTaggingRequest.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("storagelensid").unmarshallLocationName("storagelensid").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(GetStorageLensConfigurationTaggingRequest.getter(GetStorageLensConfigurationTaggingRequest::accountId)).setter(GetStorageLensConfigurationTaggingRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD, ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("storagelensid", CONFIG_ID_FIELD);
            this.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        }
    });
    private final String configId;
    private final String accountId;

    private GetStorageLensConfigurationTaggingRequest(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.accountId = builder.accountId;
    }

    public final String configId() {
        return this.configId;
    }

    public final String accountId() {
        return this.accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStorageLensConfigurationTaggingRequest)) {
            return false;
        }
        GetStorageLensConfigurationTaggingRequest other = (GetStorageLensConfigurationTaggingRequest)((Object)obj);
        return Objects.equals(this.configId(), other.configId()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"GetStorageLensConfigurationTaggingRequest").add("ConfigId", (Object)this.configId()).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetStorageLensConfigurationTaggingRequest, T> g) {
        return obj -> g.apply((GetStorageLensConfigurationTaggingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String configId;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStorageLensConfigurationTaggingRequest model) {
            super(model);
            this.configId(model.configId);
            this.accountId(model.accountId);
        }

        public final String getConfigId() {
            return this.configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStorageLensConfigurationTaggingRequest build() {
            return new GetStorageLensConfigurationTaggingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStorageLensConfigurationTaggingRequest> {
        public Builder configId(String var1);

        public Builder accountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

