/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.internal;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3control.S3ControlServiceClientConfiguration;
import software.amazon.awssdk.services.s3control.auth.scheme.S3ControlAuthSchemeProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3ControlServiceClientConfigurationBuilder
implements S3ControlServiceClientConfiguration.Builder {
    private final SdkClientConfiguration.Builder config;

    public S3ControlServiceClientConfigurationBuilder() {
        this(SdkClientConfiguration.builder());
    }

    public S3ControlServiceClientConfigurationBuilder(SdkClientConfiguration.Builder config) {
        this.config = config;
    }

    @Override
    public S3ControlServiceClientConfiguration.Builder overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.config.putAll(overrideConfiguration);
        return this;
    }

    @Override
    public ClientOverrideConfiguration overrideConfiguration() {
        return (ClientOverrideConfiguration)this.config.asOverrideConfigurationBuilder().build();
    }

    @Override
    public S3ControlServiceClientConfiguration.Builder endpointOverride(URI endpointOverride) {
        if (endpointOverride != null) {
            this.config.option((ClientOption)SdkClientOption.ENDPOINT, (Object)endpointOverride);
            this.config.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN, (Object)true);
        } else {
            this.config.option((ClientOption)SdkClientOption.ENDPOINT, null);
            this.config.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN, (Object)false);
        }
        return this;
    }

    @Override
    public URI endpointOverride() {
        if (Boolean.TRUE.equals(this.config.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            return (URI)this.config.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return null;
    }

    @Override
    public S3ControlServiceClientConfiguration.Builder endpointProvider(EndpointProvider endpointProvider) {
        this.config.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    @Override
    public EndpointProvider endpointProvider() {
        return (EndpointProvider)this.config.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
    }

    @Override
    public S3ControlServiceClientConfiguration.Builder region(Region region) {
        this.config.option((ClientOption)AwsClientOption.AWS_REGION, (Object)region);
        return this;
    }

    @Override
    public Region region() {
        return (Region)this.config.option((ClientOption)AwsClientOption.AWS_REGION);
    }

    @Override
    public S3ControlServiceClientConfiguration.Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
        this.config.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, credentialsProvider);
        return this;
    }

    @Override
    public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider() {
        return (IdentityProvider)this.config.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
    }

    @Override
    public S3ControlServiceClientConfiguration.Builder putAuthScheme(AuthScheme<?> authScheme) {
        ((Map)this.config.computeOptionIfAbsent((ClientOption)SdkClientOption.AUTH_SCHEMES, HashMap::new)).put(authScheme.schemeId(), authScheme);
        return this;
    }

    @Override
    public Map<String, AuthScheme<?>> authSchemes() {
        Map authSchemes = (Map)this.config.option((ClientOption)SdkClientOption.AUTH_SCHEMES);
        return Collections.unmodifiableMap(authSchemes == null ? Collections.emptyMap() : authSchemes);
    }

    @Override
    public S3ControlServiceClientConfiguration.Builder authSchemeProvider(S3ControlAuthSchemeProvider authSchemeProvider) {
        this.config.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)authSchemeProvider);
        return this;
    }

    @Override
    public S3ControlAuthSchemeProvider authSchemeProvider() {
        AuthSchemeProvider result = (AuthSchemeProvider)this.config.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER);
        if (result == null) {
            return null;
        }
        return (S3ControlAuthSchemeProvider)Validate.isInstanceOf(S3ControlAuthSchemeProvider.class, (Object)result, (String)("Expected an instance of " + S3ControlAuthSchemeProvider.class.getSimpleName()), (Object[])new Object[0]);
    }

    @Override
    public S3ControlServiceClientConfiguration build() {
        return new S3ControlServiceClientConfiguration(this);
    }
}

