/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.ServiceConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.services.s3control.S3ControlBaseClientBuilder;
import software.amazon.awssdk.services.s3control.S3ControlConfiguration;
import software.amazon.awssdk.services.s3control.auth.scheme.S3ControlAuthSchemeProvider;
import software.amazon.awssdk.services.s3control.auth.scheme.internal.S3ControlAuthSchemeInterceptor;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlClientContextParams;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointProvider;
import software.amazon.awssdk.services.s3control.endpoints.internal.S3ControlRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.s3control.endpoints.internal.S3ControlResolveEndpointInterceptor;
import software.amazon.awssdk.services.s3control.internal.S3ControlServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.s3control.internal.SdkClientConfigurationUtil;
import software.amazon.awssdk.services.s3control.internal.interceptors.ConfigureSignerInterceptor;
import software.amazon.awssdk.services.s3control.internal.interceptors.PayloadSigningInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
abstract class DefaultS3ControlBaseClientBuilder<B extends S3ControlBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    private final Map<String, AuthScheme<?>> additionalAuthSchemes = new HashMap();

    DefaultS3ControlBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "s3-control";
    }

    protected final String serviceName() {
        return "S3Control";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)this.defaultAuthSchemeProvider()).option((ClientOption)SdkClientOption.AUTH_SCHEMES, this.authSchemes()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false).option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION, (Object)((ServiceConfiguration)S3ControlConfiguration.builder().build())));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new S3ControlAuthSchemeInterceptor());
        endpointInterceptors.add(new S3ControlResolveEndpointInterceptor());
        endpointInterceptors.add(new S3ControlRequestSetEndpointInterceptor());
        endpointInterceptors.add(new ConfigureSignerInterceptor());
        endpointInterceptors.add(new PayloadSigningInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/s3control/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        S3ControlConfiguration.Builder serviceConfigBuilder = ((S3ControlConfiguration)config.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION)).toBuilder();
        serviceConfigBuilder.profileFile(serviceConfigBuilder.profileFileSupplier() != null ? serviceConfigBuilder.profileFileSupplier() : (Supplier)config.option((ClientOption)SdkClientOption.PROFILE_FILE_SUPPLIER));
        serviceConfigBuilder.profileName(serviceConfigBuilder.profileName() != null ? serviceConfigBuilder.profileName() : (String)config.option((ClientOption)SdkClientOption.PROFILE_NAME));
        if (serviceConfigBuilder.dualstackEnabled() != null) {
            Validate.validState((config.option((ClientOption)AwsClientOption.DUALSTACK_ENDPOINT_ENABLED) == null ? 1 : 0) != 0, (String)"Dualstack has been configured on both S3ControlConfiguration and the client/global level. Please limit dualstack configuration to one location.", (Object[])new Object[0]);
        } else {
            serviceConfigBuilder.dualstackEnabled((Boolean)config.option((ClientOption)AwsClientOption.DUALSTACK_ENDPOINT_ENABLED));
        }
        if (serviceConfigBuilder.fipsModeEnabled() != null) {
            Validate.validState((config.option(AwsClientOption.FIPS_ENDPOINT_ENABLED) == null ? 1 : 0) != 0, (String)"Fips has been configured on both S3ControlConfiguration and the client/global level. Please limit fips configuration to one location.", (Object[])new Object[0]);
        } else {
            serviceConfigBuilder.fipsModeEnabled((Boolean)config.option(AwsClientOption.FIPS_ENDPOINT_ENABLED));
        }
        if (serviceConfigBuilder.useArnRegionEnabled() != null) {
            Validate.validState((this.clientContextParams.get(S3ControlClientContextParams.USE_ARN_REGION) == null ? 1 : 0) != 0, (String)"UseArnRegion has been configured on both S3ControlConfiguration and the client/global level. Please limit UseArnRegion configuration to one location.", (Object[])new Object[0]);
        } else {
            serviceConfigBuilder.useArnRegionEnabled((Boolean)this.clientContextParams.get(S3ControlClientContextParams.USE_ARN_REGION));
        }
        S3ControlConfiguration finalServiceConfig = (S3ControlConfiguration)serviceConfigBuilder.build();
        this.clientContextParams.put(S3ControlClientContextParams.USE_ARN_REGION, (Object)finalServiceConfig.useArnRegionEnabled());
        SdkClientConfiguration.Builder builder = config.toBuilder();
        builder.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).option((ClientOption)AwsClientOption.DUALSTACK_ENDPOINT_ENABLED, (Object)finalServiceConfig.dualstackEnabled()).option(AwsClientOption.FIPS_ENDPOINT_ENABLED, (Object)finalServiceConfig.fipsModeEnabled()).option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION, (Object)finalServiceConfig).option((ClientOption)SdkClientOption.CLIENT_CONTEXT_PARAMS, (Object)this.clientContextParams.build());
        return builder.build();
    }

    protected final String signingName() {
        return "s3";
    }

    private S3ControlEndpointProvider defaultEndpointProvider() {
        return S3ControlEndpointProvider.defaultProvider();
    }

    public B authSchemeProvider(S3ControlAuthSchemeProvider authSchemeProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)authSchemeProvider);
        return (B)((S3ControlBaseClientBuilder)this.thisBuilder());
    }

    private S3ControlAuthSchemeProvider defaultAuthSchemeProvider() {
        return S3ControlAuthSchemeProvider.defaultProvider();
    }

    public B putAuthScheme(AuthScheme<?> authScheme) {
        this.additionalAuthSchemes.put(authScheme.schemeId(), authScheme);
        return (B)((S3ControlBaseClientBuilder)this.thisBuilder());
    }

    private Map<String, AuthScheme<?>> authSchemes() {
        HashMap<String, Object> schemes = new HashMap<String, Object>(2 + this.additionalAuthSchemes.size());
        AwsV4AuthScheme awsV4AuthScheme = AwsV4AuthScheme.create();
        schemes.put(awsV4AuthScheme.schemeId(), awsV4AuthScheme);
        NoAuthAuthScheme noAuthAuthScheme = NoAuthAuthScheme.create();
        schemes.put(noAuthAuthScheme.schemeId(), noAuthAuthScheme);
        schemes.putAll(this.additionalAuthSchemes);
        return Collections.unmodifiableMap(schemes);
    }

    public B useArnRegion(Boolean useArnRegion) {
        this.clientContextParams.put(S3ControlClientContextParams.USE_ARN_REGION, (Object)useArnRegion);
        return (B)((S3ControlBaseClientBuilder)this.thisBuilder());
    }

    public B serviceConfiguration(S3ControlConfiguration serviceConfiguration) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION, (Object)serviceConfiguration);
        return (B)((S3ControlBaseClientBuilder)this.thisBuilder());
    }

    public void setServiceConfiguration(S3ControlConfiguration serviceConfiguration) {
        this.serviceConfiguration(serviceConfiguration);
    }

    protected SdkClientConfiguration setOverrides(SdkClientConfiguration configuration) {
        ClientOverrideConfiguration overrideConfiguration = this.overrideConfiguration();
        if (overrideConfiguration == null) {
            return configuration;
        }
        return SdkClientConfigurationUtil.copyOverridesToConfiguration(overrideConfiguration, configuration.toBuilder()).build();
    }

    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        List plugins = this.plugins();
        if (plugins.isEmpty()) {
            return config;
        }
        S3ControlServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = S3ControlServiceClientConfigurationBuilder.builder(config.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.overrideConfiguration(serviceConfigBuilder.overrideConfiguration());
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
    }
}

