/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3control.DefaultS3ControlBaseClientBuilder;
import software.amazon.awssdk.services.s3control.DefaultS3ControlClient;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.S3ControlClientBuilder;
import software.amazon.awssdk.services.s3control.S3ControlServiceClientConfiguration;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointProvider;

@SdkInternalApi
final class DefaultS3ControlClientBuilder
extends DefaultS3ControlBaseClientBuilder<S3ControlClientBuilder, S3ControlClient>
implements S3ControlClientBuilder {
    DefaultS3ControlClientBuilder() {
    }

    @Override
    public DefaultS3ControlClientBuilder endpointProvider(S3ControlEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final S3ControlClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultS3ControlClientBuilder.validateClientOptions(clientConfiguration);
        S3ControlServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultS3ControlClient client = new DefaultS3ControlClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private S3ControlServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return S3ControlServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

