/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class S3ControlEndpointParams
implements ToCopyableBuilder<Builder, S3ControlEndpointParams> {
    private final Region region;
    private final Boolean useFIPS;
    private final Boolean useDualStack;
    private final String endpoint;
    private final String accountId;
    private final Boolean requiresAccountId;
    private final String outpostId;
    private final String bucket;
    private final String accessPointName;
    private final Boolean useArnRegion;

    private S3ControlEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useFIPS = builder.useFIPS;
        this.useDualStack = builder.useDualStack;
        this.endpoint = builder.endpoint;
        this.accountId = builder.accountId;
        this.requiresAccountId = builder.requiresAccountId;
        this.outpostId = builder.outpostId;
        this.bucket = builder.bucket;
        this.accessPointName = builder.accessPointName;
        this.useArnRegion = builder.useArnRegion;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return this.region;
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public Boolean useDualStack() {
        return this.useDualStack;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String accountId() {
        return this.accountId;
    }

    public Boolean requiresAccountId() {
        return this.requiresAccountId;
    }

    public String outpostId() {
        return this.outpostId;
    }

    public String bucket() {
        return this.bucket;
    }

    public String accessPointName() {
        return this.accessPointName;
    }

    public Boolean useArnRegion() {
        return this.useArnRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Region region;
        private Boolean useFIPS = false;
        private Boolean useDualStack = false;
        private String endpoint;
        private String accountId;
        private Boolean requiresAccountId;
        private String outpostId;
        private String bucket;
        private String accessPointName;
        private Boolean useArnRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ControlEndpointParams builder) {
            this.region = builder.region;
            this.useFIPS = builder.useFIPS;
            this.useDualStack = builder.useDualStack;
            this.endpoint = builder.endpoint;
            this.accountId = builder.accountId;
            this.requiresAccountId = builder.requiresAccountId;
            this.outpostId = builder.outpostId;
            this.bucket = builder.bucket;
            this.accessPointName = builder.accessPointName;
            this.useArnRegion = builder.useArnRegion;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Builder requiresAccountId(Boolean requiresAccountId) {
            this.requiresAccountId = requiresAccountId;
            return this;
        }

        @Override
        public Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        @Override
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public Builder accessPointName(String accessPointName) {
            this.accessPointName = accessPointName;
            return this;
        }

        @Override
        public Builder useArnRegion(Boolean useArnRegion) {
            this.useArnRegion = useArnRegion;
            return this;
        }

        @Override
        public S3ControlEndpointParams build() {
            return new S3ControlEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3ControlEndpointParams> {
        public Builder region(Region var1);

        public Builder useFips(Boolean var1);

        public Builder useDualStack(Boolean var1);

        public Builder endpoint(String var1);

        public Builder accountId(String var1);

        public Builder requiresAccountId(Boolean var1);

        public Builder outpostId(String var1);

        public Builder bucket(String var1);

        public Builder accessPointName(String var1);

        public Builder useArnRegion(Boolean var1);

        public S3ControlEndpointParams build();
    }
}

