/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.JobFailure;
import software.amazon.awssdk.services.s3control.model.JobFailureListCopier;
import software.amazon.awssdk.services.s3control.model.JobManifest;
import software.amazon.awssdk.services.s3control.model.JobManifestGenerator;
import software.amazon.awssdk.services.s3control.model.JobOperation;
import software.amazon.awssdk.services.s3control.model.JobProgressSummary;
import software.amazon.awssdk.services.s3control.model.JobReport;
import software.amazon.awssdk.services.s3control.model.JobStatus;
import software.amazon.awssdk.services.s3control.model.S3GeneratedManifestDescriptor;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDescriptor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDescriptor> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(JobDescriptor.getter(JobDescriptor::jobId)).setter(JobDescriptor.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").unmarshallLocationName("JobId").build()}).build();
    private static final SdkField<Boolean> CONFIRMATION_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ConfirmationRequired").getter(JobDescriptor.getter(JobDescriptor::confirmationRequired)).setter(JobDescriptor.setter(Builder::confirmationRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfirmationRequired").unmarshallLocationName("ConfirmationRequired").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(JobDescriptor.getter(JobDescriptor::description)).setter(JobDescriptor.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobArn").getter(JobDescriptor.getter(JobDescriptor::jobArn)).setter(JobDescriptor.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").unmarshallLocationName("JobArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(JobDescriptor.getter(JobDescriptor::statusAsString)).setter(JobDescriptor.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<JobManifest> MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Manifest").getter(JobDescriptor.getter(JobDescriptor::manifest)).setter(JobDescriptor.setter(Builder::manifest)).constructor(JobManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manifest").unmarshallLocationName("Manifest").build()}).build();
    private static final SdkField<JobOperation> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operation").getter(JobDescriptor.getter(JobDescriptor::operation)).setter(JobDescriptor.setter(Builder::operation)).constructor(JobOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").unmarshallLocationName("Operation").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(JobDescriptor.getter(JobDescriptor::priority)).setter(JobDescriptor.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").unmarshallLocationName("Priority").build()}).build();
    private static final SdkField<JobProgressSummary> PROGRESS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressSummary").getter(JobDescriptor.getter(JobDescriptor::progressSummary)).setter(JobDescriptor.setter(Builder::progressSummary)).constructor(JobProgressSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressSummary").unmarshallLocationName("ProgressSummary").build()}).build();
    private static final SdkField<String> STATUS_UPDATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusUpdateReason").getter(JobDescriptor.getter(JobDescriptor::statusUpdateReason)).setter(JobDescriptor.setter(Builder::statusUpdateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusUpdateReason").unmarshallLocationName("StatusUpdateReason").build()}).build();
    private static final SdkField<List<JobFailure>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailureReasons").getter(JobDescriptor.getter(JobDescriptor::failureReasons)).setter(JobDescriptor.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReasons").unmarshallLocationName("FailureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<JobReport> REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Report").getter(JobDescriptor.getter(JobDescriptor::report)).setter(JobDescriptor.setter(Builder::report)).constructor(JobReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Report").unmarshallLocationName("Report").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(JobDescriptor.getter(JobDescriptor::creationTime)).setter(JobDescriptor.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TERMINATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TerminationDate").getter(JobDescriptor.getter(JobDescriptor::terminationDate)).setter(JobDescriptor.setter(Builder::terminationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationDate").unmarshallLocationName("TerminationDate").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(JobDescriptor.getter(JobDescriptor::roleArn)).setter(JobDescriptor.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").unmarshallLocationName("RoleArn").build()}).build();
    private static final SdkField<Instant> SUSPENDED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SuspendedDate").getter(JobDescriptor.getter(JobDescriptor::suspendedDate)).setter(JobDescriptor.setter(Builder::suspendedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendedDate").unmarshallLocationName("SuspendedDate").build()}).build();
    private static final SdkField<String> SUSPENDED_CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SuspendedCause").getter(JobDescriptor.getter(JobDescriptor::suspendedCause)).setter(JobDescriptor.setter(Builder::suspendedCause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendedCause").unmarshallLocationName("SuspendedCause").build()}).build();
    private static final SdkField<JobManifestGenerator> MANIFEST_GENERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestGenerator").getter(JobDescriptor.getter(JobDescriptor::manifestGenerator)).setter(JobDescriptor.setter(Builder::manifestGenerator)).constructor(JobManifestGenerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestGenerator").unmarshallLocationName("ManifestGenerator").build()}).build();
    private static final SdkField<S3GeneratedManifestDescriptor> GENERATED_MANIFEST_DESCRIPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeneratedManifestDescriptor").getter(JobDescriptor.getter(JobDescriptor::generatedManifestDescriptor)).setter(JobDescriptor.setter(Builder::generatedManifestDescriptor)).constructor(S3GeneratedManifestDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedManifestDescriptor").unmarshallLocationName("GeneratedManifestDescriptor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, CONFIRMATION_REQUIRED_FIELD, DESCRIPTION_FIELD, JOB_ARN_FIELD, STATUS_FIELD, MANIFEST_FIELD, OPERATION_FIELD, PRIORITY_FIELD, PROGRESS_SUMMARY_FIELD, STATUS_UPDATE_REASON_FIELD, FAILURE_REASONS_FIELD, REPORT_FIELD, CREATION_TIME_FIELD, TERMINATION_DATE_FIELD, ROLE_ARN_FIELD, SUSPENDED_DATE_FIELD, SUSPENDED_CAUSE_FIELD, MANIFEST_GENERATOR_FIELD, GENERATED_MANIFEST_DESCRIPTOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final Boolean confirmationRequired;
    private final String description;
    private final String jobArn;
    private final String status;
    private final JobManifest manifest;
    private final JobOperation operation;
    private final Integer priority;
    private final JobProgressSummary progressSummary;
    private final String statusUpdateReason;
    private final List<JobFailure> failureReasons;
    private final JobReport report;
    private final Instant creationTime;
    private final Instant terminationDate;
    private final String roleArn;
    private final Instant suspendedDate;
    private final String suspendedCause;
    private final JobManifestGenerator manifestGenerator;
    private final S3GeneratedManifestDescriptor generatedManifestDescriptor;

    private JobDescriptor(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.confirmationRequired = builder.confirmationRequired;
        this.description = builder.description;
        this.jobArn = builder.jobArn;
        this.status = builder.status;
        this.manifest = builder.manifest;
        this.operation = builder.operation;
        this.priority = builder.priority;
        this.progressSummary = builder.progressSummary;
        this.statusUpdateReason = builder.statusUpdateReason;
        this.failureReasons = builder.failureReasons;
        this.report = builder.report;
        this.creationTime = builder.creationTime;
        this.terminationDate = builder.terminationDate;
        this.roleArn = builder.roleArn;
        this.suspendedDate = builder.suspendedDate;
        this.suspendedCause = builder.suspendedCause;
        this.manifestGenerator = builder.manifestGenerator;
        this.generatedManifestDescriptor = builder.generatedManifestDescriptor;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Boolean confirmationRequired() {
        return this.confirmationRequired;
    }

    public final String description() {
        return this.description;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final JobManifest manifest() {
        return this.manifest;
    }

    public final JobOperation operation() {
        return this.operation;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final JobProgressSummary progressSummary() {
        return this.progressSummary;
    }

    public final String statusUpdateReason() {
        return this.statusUpdateReason;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<JobFailure> failureReasons() {
        return this.failureReasons;
    }

    public final JobReport report() {
        return this.report;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant terminationDate() {
        return this.terminationDate;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant suspendedDate() {
        return this.suspendedDate;
    }

    public final String suspendedCause() {
        return this.suspendedCause;
    }

    public final JobManifestGenerator manifestGenerator() {
        return this.manifestGenerator;
    }

    public final S3GeneratedManifestDescriptor generatedManifestDescriptor() {
        return this.generatedManifestDescriptor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusUpdateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.report());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspendedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspendedCause());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestGenerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedManifestDescriptor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDescriptor)) {
            return false;
        }
        JobDescriptor other = (JobDescriptor)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.confirmationRequired(), other.confirmationRequired()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.manifest(), other.manifest()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.progressSummary(), other.progressSummary()) && Objects.equals(this.statusUpdateReason(), other.statusUpdateReason()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.report(), other.report()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.terminationDate(), other.terminationDate()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.suspendedDate(), other.suspendedDate()) && Objects.equals(this.suspendedCause(), other.suspendedCause()) && Objects.equals(this.manifestGenerator(), other.manifestGenerator()) && Objects.equals(this.generatedManifestDescriptor(), other.generatedManifestDescriptor());
    }

    public final String toString() {
        return ToString.builder((String)"JobDescriptor").add("JobId", (Object)this.jobId()).add("ConfirmationRequired", (Object)this.confirmationRequired()).add("Description", (Object)this.description()).add("JobArn", (Object)this.jobArn()).add("Status", (Object)this.statusAsString()).add("Manifest", (Object)this.manifest()).add("Operation", (Object)this.operation()).add("Priority", (Object)this.priority()).add("ProgressSummary", (Object)this.progressSummary()).add("StatusUpdateReason", (Object)this.statusUpdateReason()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("Report", (Object)this.report()).add("CreationTime", (Object)this.creationTime()).add("TerminationDate", (Object)this.terminationDate()).add("RoleArn", (Object)this.roleArn()).add("SuspendedDate", (Object)this.suspendedDate()).add("SuspendedCause", (Object)this.suspendedCause()).add("ManifestGenerator", (Object)this.manifestGenerator()).add("GeneratedManifestDescriptor", (Object)this.generatedManifestDescriptor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "ConfirmationRequired": {
                return Optional.ofNullable(clazz.cast(this.confirmationRequired()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "JobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Manifest": {
                return Optional.ofNullable(clazz.cast(this.manifest()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "ProgressSummary": {
                return Optional.ofNullable(clazz.cast(this.progressSummary()));
            }
            case "StatusUpdateReason": {
                return Optional.ofNullable(clazz.cast(this.statusUpdateReason()));
            }
            case "FailureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "Report": {
                return Optional.ofNullable(clazz.cast(this.report()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TerminationDate": {
                return Optional.ofNullable(clazz.cast(this.terminationDate()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SuspendedDate": {
                return Optional.ofNullable(clazz.cast(this.suspendedDate()));
            }
            case "SuspendedCause": {
                return Optional.ofNullable(clazz.cast(this.suspendedCause()));
            }
            case "ManifestGenerator": {
                return Optional.ofNullable(clazz.cast(this.manifestGenerator()));
            }
            case "GeneratedManifestDescriptor": {
                return Optional.ofNullable(clazz.cast(this.generatedManifestDescriptor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDescriptor, T> g) {
        return obj -> g.apply((JobDescriptor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private Boolean confirmationRequired;
        private String description;
        private String jobArn;
        private String status;
        private JobManifest manifest;
        private JobOperation operation;
        private Integer priority;
        private JobProgressSummary progressSummary;
        private String statusUpdateReason;
        private List<JobFailure> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private JobReport report;
        private Instant creationTime;
        private Instant terminationDate;
        private String roleArn;
        private Instant suspendedDate;
        private String suspendedCause;
        private JobManifestGenerator manifestGenerator;
        private S3GeneratedManifestDescriptor generatedManifestDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDescriptor model) {
            this.jobId(model.jobId);
            this.confirmationRequired(model.confirmationRequired);
            this.description(model.description);
            this.jobArn(model.jobArn);
            this.status(model.status);
            this.manifest(model.manifest);
            this.operation(model.operation);
            this.priority(model.priority);
            this.progressSummary(model.progressSummary);
            this.statusUpdateReason(model.statusUpdateReason);
            this.failureReasons(model.failureReasons);
            this.report(model.report);
            this.creationTime(model.creationTime);
            this.terminationDate(model.terminationDate);
            this.roleArn(model.roleArn);
            this.suspendedDate(model.suspendedDate);
            this.suspendedCause(model.suspendedCause);
            this.manifestGenerator(model.manifestGenerator);
            this.generatedManifestDescriptor(model.generatedManifestDescriptor);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Boolean getConfirmationRequired() {
            return this.confirmationRequired;
        }

        public final void setConfirmationRequired(Boolean confirmationRequired) {
            this.confirmationRequired = confirmationRequired;
        }

        @Override
        @Transient
        public final Builder confirmationRequired(Boolean confirmationRequired) {
            this.confirmationRequired = confirmationRequired;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        @Transient
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final JobManifest.Builder getManifest() {
            return this.manifest != null ? this.manifest.toBuilder() : null;
        }

        public final void setManifest(JobManifest.BuilderImpl manifest) {
            this.manifest = manifest != null ? manifest.build() : null;
        }

        @Override
        @Transient
        public final Builder manifest(JobManifest manifest) {
            this.manifest = manifest;
            return this;
        }

        public final JobOperation.Builder getOperation() {
            return this.operation != null ? this.operation.toBuilder() : null;
        }

        public final void setOperation(JobOperation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        @Transient
        public final Builder operation(JobOperation operation) {
            this.operation = operation;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final JobProgressSummary.Builder getProgressSummary() {
            return this.progressSummary != null ? this.progressSummary.toBuilder() : null;
        }

        public final void setProgressSummary(JobProgressSummary.BuilderImpl progressSummary) {
            this.progressSummary = progressSummary != null ? progressSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder progressSummary(JobProgressSummary progressSummary) {
            this.progressSummary = progressSummary;
            return this;
        }

        public final String getStatusUpdateReason() {
            return this.statusUpdateReason;
        }

        public final void setStatusUpdateReason(String statusUpdateReason) {
            this.statusUpdateReason = statusUpdateReason;
        }

        @Override
        @Transient
        public final Builder statusUpdateReason(String statusUpdateReason) {
            this.statusUpdateReason = statusUpdateReason;
            return this;
        }

        public final List<JobFailure.Builder> getFailureReasons() {
            List<JobFailure.Builder> result = JobFailureListCopier.copyToBuilder(this.failureReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailureReasons(Collection<JobFailure.BuilderImpl> failureReasons) {
            this.failureReasons = JobFailureListCopier.copyFromBuilder(failureReasons);
        }

        @Override
        @Transient
        public final Builder failureReasons(Collection<JobFailure> failureReasons) {
            this.failureReasons = JobFailureListCopier.copy(failureReasons);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failureReasons(JobFailure ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failureReasons(Consumer<JobFailure.Builder> ... failureReasons) {
            this.failureReasons(Stream.of(failureReasons).map(c -> (JobFailure)((JobFailure.Builder)JobFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final JobReport.Builder getReport() {
            return this.report != null ? this.report.toBuilder() : null;
        }

        public final void setReport(JobReport.BuilderImpl report) {
            this.report = report != null ? report.build() : null;
        }

        @Override
        @Transient
        public final Builder report(JobReport report) {
            this.report = report;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getTerminationDate() {
            return this.terminationDate;
        }

        public final void setTerminationDate(Instant terminationDate) {
            this.terminationDate = terminationDate;
        }

        @Override
        @Transient
        public final Builder terminationDate(Instant terminationDate) {
            this.terminationDate = terminationDate;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getSuspendedDate() {
            return this.suspendedDate;
        }

        public final void setSuspendedDate(Instant suspendedDate) {
            this.suspendedDate = suspendedDate;
        }

        @Override
        @Transient
        public final Builder suspendedDate(Instant suspendedDate) {
            this.suspendedDate = suspendedDate;
            return this;
        }

        public final String getSuspendedCause() {
            return this.suspendedCause;
        }

        public final void setSuspendedCause(String suspendedCause) {
            this.suspendedCause = suspendedCause;
        }

        @Override
        @Transient
        public final Builder suspendedCause(String suspendedCause) {
            this.suspendedCause = suspendedCause;
            return this;
        }

        public final JobManifestGenerator.Builder getManifestGenerator() {
            return this.manifestGenerator != null ? this.manifestGenerator.toBuilder() : null;
        }

        public final void setManifestGenerator(JobManifestGenerator.BuilderImpl manifestGenerator) {
            this.manifestGenerator = manifestGenerator != null ? manifestGenerator.build() : null;
        }

        @Override
        @Transient
        public final Builder manifestGenerator(JobManifestGenerator manifestGenerator) {
            this.manifestGenerator = manifestGenerator;
            return this;
        }

        public final S3GeneratedManifestDescriptor.Builder getGeneratedManifestDescriptor() {
            return this.generatedManifestDescriptor != null ? this.generatedManifestDescriptor.toBuilder() : null;
        }

        public final void setGeneratedManifestDescriptor(S3GeneratedManifestDescriptor.BuilderImpl generatedManifestDescriptor) {
            this.generatedManifestDescriptor = generatedManifestDescriptor != null ? generatedManifestDescriptor.build() : null;
        }

        @Override
        @Transient
        public final Builder generatedManifestDescriptor(S3GeneratedManifestDescriptor generatedManifestDescriptor) {
            this.generatedManifestDescriptor = generatedManifestDescriptor;
            return this;
        }

        public JobDescriptor build() {
            return new JobDescriptor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDescriptor> {
        public Builder jobId(String var1);

        public Builder confirmationRequired(Boolean var1);

        public Builder description(String var1);

        public Builder jobArn(String var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder manifest(JobManifest var1);

        default public Builder manifest(Consumer<JobManifest.Builder> manifest) {
            return this.manifest((JobManifest)((JobManifest.Builder)JobManifest.builder().applyMutation(manifest)).build());
        }

        public Builder operation(JobOperation var1);

        default public Builder operation(Consumer<JobOperation.Builder> operation) {
            return this.operation((JobOperation)((JobOperation.Builder)JobOperation.builder().applyMutation(operation)).build());
        }

        public Builder priority(Integer var1);

        public Builder progressSummary(JobProgressSummary var1);

        default public Builder progressSummary(Consumer<JobProgressSummary.Builder> progressSummary) {
            return this.progressSummary((JobProgressSummary)((JobProgressSummary.Builder)JobProgressSummary.builder().applyMutation(progressSummary)).build());
        }

        public Builder statusUpdateReason(String var1);

        public Builder failureReasons(Collection<JobFailure> var1);

        public Builder failureReasons(JobFailure ... var1);

        public Builder failureReasons(Consumer<JobFailure.Builder> ... var1);

        public Builder report(JobReport var1);

        default public Builder report(Consumer<JobReport.Builder> report) {
            return this.report((JobReport)((JobReport.Builder)JobReport.builder().applyMutation(report)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder terminationDate(Instant var1);

        public Builder roleArn(String var1);

        public Builder suspendedDate(Instant var1);

        public Builder suspendedCause(String var1);

        public Builder manifestGenerator(JobManifestGenerator var1);

        default public Builder manifestGenerator(Consumer<JobManifestGenerator.Builder> manifestGenerator) {
            return this.manifestGenerator((JobManifestGenerator)((JobManifestGenerator.Builder)JobManifestGenerator.builder().applyMutation(manifestGenerator)).build());
        }

        public Builder generatedManifestDescriptor(S3GeneratedManifestDescriptor var1);

        default public Builder generatedManifestDescriptor(Consumer<S3GeneratedManifestDescriptor.Builder> generatedManifestDescriptor) {
            return this.generatedManifestDescriptor((S3GeneratedManifestDescriptor)((S3GeneratedManifestDescriptor.Builder)S3GeneratedManifestDescriptor.builder().applyMutation(generatedManifestDescriptor)).build());
        }
    }
}

