/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksumRequired;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointResource;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3control.S3ControlBucketResource;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.S3ArnableField;
import software.amazon.awssdk.services.s3control.internal.S3ControlArnConverter;
import software.amazon.awssdk.services.s3control.internal.S3ControlInternalExecutionAttribute;
import software.amazon.awssdk.services.s3control.model.BadRequestException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3control.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3control.model.CreateJobRequest;
import software.amazon.awssdk.services.s3control.model.CreateJobResponse;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DescribeJobRequest;
import software.amazon.awssdk.services.s3control.model.DescribeJobResponse;
import software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest;
import software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.IdempotencyException;
import software.amazon.awssdk.services.s3control.model.InternalServiceException;
import software.amazon.awssdk.services.s3control.model.InvalidNextTokenException;
import software.amazon.awssdk.services.s3control.model.InvalidRequestException;
import software.amazon.awssdk.services.s3control.model.JobStatusException;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListJobsRequest;
import software.amazon.awssdk.services.s3control.model.ListJobsResponse;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse;
import software.amazon.awssdk.services.s3control.model.NoSuchPublicAccessBlockConfigurationException;
import software.amazon.awssdk.services.s3control.model.NotFoundException;
import software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.S3ControlException;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3control.model.TooManyTagsException;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse;
import software.amazon.awssdk.services.s3control.paginators.ListAccessPointsForObjectLambdaIterable;
import software.amazon.awssdk.services.s3control.paginators.ListAccessPointsIterable;
import software.amazon.awssdk.services.s3control.paginators.ListJobsIterable;
import software.amazon.awssdk.services.s3control.paginators.ListMultiRegionAccessPointsIterable;
import software.amazon.awssdk.services.s3control.paginators.ListRegionalBucketsIterable;
import software.amazon.awssdk.services.s3control.paginators.ListStorageLensConfigurationsIterable;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeletePublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeMultiRegionAccessPointOperationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointConfigurationForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListMultiRegionAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListRegionalBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListStorageLensConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointConfigurationForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutMultiRegionAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobPriorityRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobStatusRequestMarshaller;
import software.amazon.awssdk.utils.HostnameValidator;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultS3ControlClient
implements S3ControlClient {
    private static final Logger log = Logger.loggerFor(DefaultS3ControlClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3ControlClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "s3";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessPointResponse createAccessPoint(CreateAccessPointRequest createAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPoint");
            String bucket = createAccessPointRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = createAccessPointRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                createAccessPointRequest = (CreateAccessPointRequest)((Object)createAccessPointRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createAccessPointRequest.accountId(), (String)"AccountId", (String)"createAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", createAccessPointRequest.accountId());
            CreateAccessPointResponse createAccessPointResponse = (CreateAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createAccessPointRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new CreateAccessPointRequestMarshaller(this.protocolFactory)));
            return createAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createAccessPoint$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessPointForObjectLambdaResponse createAccessPointForObjectLambda(CreateAccessPointForObjectLambdaRequest createAccessPointForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateAccessPointForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPointForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createAccessPointForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"createAccessPointForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", createAccessPointForObjectLambdaRequest.accountId());
            CreateAccessPointForObjectLambdaResponse createAccessPointForObjectLambdaResponse = (CreateAccessPointForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPointForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createAccessPointForObjectLambdaRequest).withMarshaller((Marshaller)new CreateAccessPointForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return createAccessPointForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createAccessPointForObjectLambda$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucket");
            CreateBucketResponse createBucketResponse = (CreateBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBucketRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new CreateBucketRequestMarshaller(this.protocolFactory)));
            return createBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createBucket$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws TooManyRequestsException, BadRequestException, IdempotencyException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJob");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createJobRequest.accountId(), (String)"AccountId", (String)"createJobRequest");
            String resolvedHostExpression = String.format("%s.", createJobRequest.accountId());
            CreateJobResponse createJobResponse = (CreateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createJobRequest).withMarshaller((Marshaller)new CreateJobRequestMarshaller(this.protocolFactory)));
            return createJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createJob$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMultiRegionAccessPointResponse createMultiRegionAccessPoint(CreateMultiRegionAccessPointRequest createMultiRegionAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateMultiRegionAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createMultiRegionAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMultiRegionAccessPoint");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createMultiRegionAccessPointRequest.accountId(), (String)"AccountId", (String)"createMultiRegionAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", createMultiRegionAccessPointRequest.accountId());
            CreateMultiRegionAccessPointResponse createMultiRegionAccessPointResponse = (CreateMultiRegionAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultiRegionAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createMultiRegionAccessPointRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new CreateMultiRegionAccessPointRequestMarshaller(this.protocolFactory)));
            return createMultiRegionAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$createMultiRegionAccessPoint$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointResponse deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPoint");
            String name = deleteAccessPointRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = deleteAccessPointRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteAccessPointRequest = (DeleteAccessPointRequest)((Object)deleteAccessPointRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointRequest.accountId());
            DeleteAccessPointResponse deleteAccessPointResponse = (DeleteAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteAccessPointRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteAccessPointRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPoint$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointForObjectLambdaResponse deleteAccessPointForObjectLambda(DeleteAccessPointForObjectLambdaRequest deleteAccessPointForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointForObjectLambdaRequest.accountId());
            DeleteAccessPointForObjectLambdaResponse deleteAccessPointForObjectLambdaResponse = (DeleteAccessPointForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteAccessPointForObjectLambdaRequest).withMarshaller((Marshaller)new DeleteAccessPointForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPointForObjectLambda$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointPolicyResponse deleteAccessPointPolicy(DeleteAccessPointPolicyRequest deleteAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointPolicy");
            String name = deleteAccessPointPolicyRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = deleteAccessPointPolicyRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteAccessPointPolicyRequest = (DeleteAccessPointPolicyRequest)((Object)deleteAccessPointPolicyRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointPolicyRequest.accountId());
            DeleteAccessPointPolicyResponse deleteAccessPointPolicyResponse = (DeleteAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteAccessPointPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPointPolicy$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointPolicyForObjectLambdaResponse deleteAccessPointPolicyForObjectLambda(DeleteAccessPointPolicyForObjectLambdaRequest deleteAccessPointPolicyForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointPolicyForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointPolicyForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointPolicyForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointPolicyForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointPolicyForObjectLambdaRequest.accountId());
            DeleteAccessPointPolicyForObjectLambdaResponse deleteAccessPointPolicyForObjectLambdaResponse = (DeleteAccessPointPolicyForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointPolicyForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteAccessPointPolicyForObjectLambdaRequest).withMarshaller((Marshaller)new DeleteAccessPointPolicyForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointPolicyForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteAccessPointPolicyForObjectLambda$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucket");
            String bucket = deleteBucketRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketRequest = (DeleteBucketRequest)((Object)deleteBucketRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketRequest.accountId(), (String)"AccountId", (String)"deleteBucketRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketRequest.accountId());
            DeleteBucketResponse deleteBucketResponse = (DeleteBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteBucketRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteBucketRequestMarshaller(this.protocolFactory)));
            return deleteBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucket$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketLifecycleConfigurationResponse deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketLifecycleConfiguration");
            String bucket = deleteBucketLifecycleConfigurationRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketLifecycleConfigurationRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketLifecycleConfigurationRequest = (DeleteBucketLifecycleConfigurationRequest)((Object)deleteBucketLifecycleConfigurationRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketLifecycleConfigurationRequest.accountId(), (String)"AccountId", (String)"deleteBucketLifecycleConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketLifecycleConfigurationRequest.accountId());
            DeleteBucketLifecycleConfigurationResponse deleteBucketLifecycleConfigurationResponse = (DeleteBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketLifecycleConfiguration").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteBucketLifecycleConfigurationRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketLifecycleConfiguration$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketPolicyResponse deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketPolicy");
            String bucket = deleteBucketPolicyRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketPolicyRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketPolicyRequest = (DeleteBucketPolicyRequest)((Object)deleteBucketPolicyRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketPolicyRequest.accountId(), (String)"AccountId", (String)"deleteBucketPolicyRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketPolicyRequest.accountId());
            DeleteBucketPolicyResponse deleteBucketPolicyResponse = (DeleteBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteBucketPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteBucketPolicyRequestMarshaller(this.protocolFactory)));
            return deleteBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketPolicy$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBucketTaggingResponse deleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketTagging");
            String bucket = deleteBucketTaggingRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketTaggingRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketTaggingRequest = (DeleteBucketTaggingRequest)((Object)deleteBucketTaggingRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketTaggingRequest.accountId(), (String)"AccountId", (String)"deleteBucketTaggingRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketTaggingRequest.accountId());
            DeleteBucketTaggingResponse deleteBucketTaggingResponse = (DeleteBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteBucketTaggingRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new DeleteBucketTaggingRequestMarshaller(this.protocolFactory)));
            return deleteBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteBucketTagging$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteJobTaggingResponse deleteJobTagging(DeleteJobTaggingRequest deleteJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJobTagging");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteJobTaggingRequest.accountId(), (String)"AccountId", (String)"deleteJobTaggingRequest");
            String resolvedHostExpression = String.format("%s.", deleteJobTaggingRequest.accountId());
            DeleteJobTaggingResponse deleteJobTaggingResponse = (DeleteJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJobTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteJobTaggingRequest).withMarshaller((Marshaller)new DeleteJobTaggingRequestMarshaller(this.protocolFactory)));
            return deleteJobTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteJobTagging$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMultiRegionAccessPointResponse deleteMultiRegionAccessPoint(DeleteMultiRegionAccessPointRequest deleteMultiRegionAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteMultiRegionAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteMultiRegionAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMultiRegionAccessPoint");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteMultiRegionAccessPointRequest.accountId(), (String)"AccountId", (String)"deleteMultiRegionAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", deleteMultiRegionAccessPointRequest.accountId());
            DeleteMultiRegionAccessPointResponse deleteMultiRegionAccessPointResponse = (DeleteMultiRegionAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMultiRegionAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteMultiRegionAccessPointRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new DeleteMultiRegionAccessPointRequestMarshaller(this.protocolFactory)));
            return deleteMultiRegionAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteMultiRegionAccessPoint$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePublicAccessBlockResponse deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deletePublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePublicAccessBlock");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deletePublicAccessBlockRequest.accountId(), (String)"AccountId", (String)"deletePublicAccessBlockRequest");
            String resolvedHostExpression = String.format("%s.", deletePublicAccessBlockRequest.accountId());
            DeletePublicAccessBlockResponse deletePublicAccessBlockResponse = (DeletePublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicAccessBlock").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deletePublicAccessBlockRequest).withMarshaller((Marshaller)new DeletePublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return deletePublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deletePublicAccessBlock$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStorageLensConfigurationResponse deleteStorageLensConfiguration(DeleteStorageLensConfigurationRequest deleteStorageLensConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteStorageLensConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStorageLensConfiguration");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteStorageLensConfigurationRequest.accountId(), (String)"AccountId", (String)"deleteStorageLensConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", deleteStorageLensConfigurationRequest.accountId());
            DeleteStorageLensConfigurationResponse deleteStorageLensConfigurationResponse = (DeleteStorageLensConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStorageLensConfiguration").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteStorageLensConfigurationRequest).withMarshaller((Marshaller)new DeleteStorageLensConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteStorageLensConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteStorageLensConfiguration$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStorageLensConfigurationTaggingResponse deleteStorageLensConfigurationTagging(DeleteStorageLensConfigurationTaggingRequest deleteStorageLensConfigurationTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteStorageLensConfigurationTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStorageLensConfigurationTagging");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteStorageLensConfigurationTaggingRequest.accountId(), (String)"AccountId", (String)"deleteStorageLensConfigurationTaggingRequest");
            String resolvedHostExpression = String.format("%s.", deleteStorageLensConfigurationTaggingRequest.accountId());
            DeleteStorageLensConfigurationTaggingResponse deleteStorageLensConfigurationTaggingResponse = (DeleteStorageLensConfigurationTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStorageLensConfigurationTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteStorageLensConfigurationTaggingRequest).withMarshaller((Marshaller)new DeleteStorageLensConfigurationTaggingRequestMarshaller(this.protocolFactory)));
            return deleteStorageLensConfigurationTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$deleteStorageLensConfigurationTagging$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, describeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJob");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)describeJobRequest.accountId(), (String)"AccountId", (String)"describeJobRequest");
            String resolvedHostExpression = String.format("%s.", describeJobRequest.accountId());
            DescribeJobResponse describeJobResponse = (DescribeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJob").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)describeJobRequest).withMarshaller((Marshaller)new DescribeJobRequestMarshaller(this.protocolFactory)));
            return describeJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$describeJob$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMultiRegionAccessPointOperationResponse describeMultiRegionAccessPointOperation(DescribeMultiRegionAccessPointOperationRequest describeMultiRegionAccessPointOperationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeMultiRegionAccessPointOperationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, describeMultiRegionAccessPointOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiRegionAccessPointOperation");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)describeMultiRegionAccessPointOperationRequest.accountId(), (String)"AccountId", (String)"describeMultiRegionAccessPointOperationRequest");
            String resolvedHostExpression = String.format("%s.", describeMultiRegionAccessPointOperationRequest.accountId());
            DescribeMultiRegionAccessPointOperationResponse describeMultiRegionAccessPointOperationResponse = (DescribeMultiRegionAccessPointOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiRegionAccessPointOperation").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)describeMultiRegionAccessPointOperationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new DescribeMultiRegionAccessPointOperationRequestMarshaller(this.protocolFactory)));
            return describeMultiRegionAccessPointOperationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$describeMultiRegionAccessPointOperation$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointResponse getAccessPoint(GetAccessPointRequest getAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPoint");
            String name = getAccessPointRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = getAccessPointRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getAccessPointRequest = (GetAccessPointRequest)((Object)getAccessPointRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointRequest.accountId(), (String)"AccountId", (String)"getAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointRequest.accountId());
            GetAccessPointResponse getAccessPointResponse = (GetAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetAccessPointRequestMarshaller(this.protocolFactory)));
            return getAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPoint$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointConfigurationForObjectLambdaResponse getAccessPointConfigurationForObjectLambda(GetAccessPointConfigurationForObjectLambdaRequest getAccessPointConfigurationForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointConfigurationForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointConfigurationForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointConfigurationForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointConfigurationForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"getAccessPointConfigurationForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointConfigurationForObjectLambdaRequest.accountId());
            GetAccessPointConfigurationForObjectLambdaResponse getAccessPointConfigurationForObjectLambdaResponse = (GetAccessPointConfigurationForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointConfigurationForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointConfigurationForObjectLambdaRequest).withMarshaller((Marshaller)new GetAccessPointConfigurationForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return getAccessPointConfigurationForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointConfigurationForObjectLambda$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointForObjectLambdaResponse getAccessPointForObjectLambda(GetAccessPointForObjectLambdaRequest getAccessPointForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"getAccessPointForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointForObjectLambdaRequest.accountId());
            GetAccessPointForObjectLambdaResponse getAccessPointForObjectLambdaResponse = (GetAccessPointForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointForObjectLambdaRequest).withMarshaller((Marshaller)new GetAccessPointForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return getAccessPointForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointForObjectLambda$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyResponse getAccessPointPolicy(GetAccessPointPolicyRequest getAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicy");
            String name = getAccessPointPolicyRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = getAccessPointPolicyRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getAccessPointPolicyRequest = (GetAccessPointPolicyRequest)((Object)getAccessPointPolicyRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyRequest.accountId());
            GetAccessPointPolicyResponse getAccessPointPolicyResponse = (GetAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicy$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyForObjectLambdaResponse getAccessPointPolicyForObjectLambda(GetAccessPointPolicyForObjectLambdaRequest getAccessPointPolicyForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyForObjectLambdaRequest.accountId());
            GetAccessPointPolicyForObjectLambdaResponse getAccessPointPolicyForObjectLambdaResponse = (GetAccessPointPolicyForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointPolicyForObjectLambdaRequest).withMarshaller((Marshaller)new GetAccessPointPolicyForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicyForObjectLambda$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyStatusResponse getAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest getAccessPointPolicyStatusRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyStatus");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyStatusRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyStatusRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyStatusRequest.accountId());
            GetAccessPointPolicyStatusResponse getAccessPointPolicyStatusResponse = (GetAccessPointPolicyStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyStatus").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointPolicyStatusRequest).withMarshaller((Marshaller)new GetAccessPointPolicyStatusRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicyStatus$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyStatusForObjectLambdaResponse getAccessPointPolicyStatusForObjectLambda(GetAccessPointPolicyStatusForObjectLambdaRequest getAccessPointPolicyStatusForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyStatusForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyStatusForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyStatusForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyStatusForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyStatusForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyStatusForObjectLambdaRequest.accountId());
            GetAccessPointPolicyStatusForObjectLambdaResponse getAccessPointPolicyStatusForObjectLambdaResponse = (GetAccessPointPolicyStatusForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyStatusForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAccessPointPolicyStatusForObjectLambdaRequest).withMarshaller((Marshaller)new GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyStatusForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getAccessPointPolicyStatusForObjectLambda$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketResponse getBucket(GetBucketRequest getBucketRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucket");
            String bucket = getBucketRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketRequest = (GetBucketRequest)((Object)getBucketRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketRequest.accountId(), (String)"AccountId", (String)"getBucketRequest");
            String resolvedHostExpression = String.format("%s.", getBucketRequest.accountId());
            GetBucketResponse getBucketResponse = (GetBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucket").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getBucketRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetBucketRequestMarshaller(this.protocolFactory)));
            return getBucketResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucket$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketLifecycleConfigurationResponse getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketLifecycleConfiguration");
            String bucket = getBucketLifecycleConfigurationRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketLifecycleConfigurationRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketLifecycleConfigurationRequest = (GetBucketLifecycleConfigurationRequest)((Object)getBucketLifecycleConfigurationRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketLifecycleConfigurationRequest.accountId(), (String)"AccountId", (String)"getBucketLifecycleConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", getBucketLifecycleConfigurationRequest.accountId());
            GetBucketLifecycleConfigurationResponse getBucketLifecycleConfigurationResponse = (GetBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLifecycleConfiguration").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getBucketLifecycleConfigurationRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return getBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketLifecycleConfiguration$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketPolicyResponse getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketPolicy");
            String bucket = getBucketPolicyRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketPolicyRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketPolicyRequest = (GetBucketPolicyRequest)((Object)getBucketPolicyRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketPolicyRequest.accountId(), (String)"AccountId", (String)"getBucketPolicyRequest");
            String resolvedHostExpression = String.format("%s.", getBucketPolicyRequest.accountId());
            GetBucketPolicyResponse getBucketPolicyResponse = (GetBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getBucketPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetBucketPolicyRequestMarshaller(this.protocolFactory)));
            return getBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketPolicy$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBucketTaggingResponse getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketTagging");
            String bucket = getBucketTaggingRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketTaggingRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketTaggingRequest = (GetBucketTaggingRequest)((Object)getBucketTaggingRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketTaggingRequest.accountId(), (String)"AccountId", (String)"getBucketTaggingRequest");
            String resolvedHostExpression = String.format("%s.", getBucketTaggingRequest.accountId());
            GetBucketTaggingResponse getBucketTaggingResponse = (GetBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getBucketTaggingRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new GetBucketTaggingRequestMarshaller(this.protocolFactory)));
            return getBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getBucketTagging$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobTaggingResponse getJobTagging(GetJobTaggingRequest getJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobTagging");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getJobTaggingRequest.accountId(), (String)"AccountId", (String)"getJobTaggingRequest");
            String resolvedHostExpression = String.format("%s.", getJobTaggingRequest.accountId());
            GetJobTaggingResponse getJobTaggingResponse = (GetJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getJobTaggingRequest).withMarshaller((Marshaller)new GetJobTaggingRequestMarshaller(this.protocolFactory)));
            return getJobTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getJobTagging$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMultiRegionAccessPointResponse getMultiRegionAccessPoint(GetMultiRegionAccessPointRequest getMultiRegionAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getMultiRegionAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPoint");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getMultiRegionAccessPointRequest.accountId(), (String)"AccountId", (String)"getMultiRegionAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", getMultiRegionAccessPointRequest.accountId());
            GetMultiRegionAccessPointResponse getMultiRegionAccessPointResponse = (GetMultiRegionAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getMultiRegionAccessPointRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new GetMultiRegionAccessPointRequestMarshaller(this.protocolFactory)));
            return getMultiRegionAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getMultiRegionAccessPoint$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMultiRegionAccessPointPolicyResponse getMultiRegionAccessPointPolicy(GetMultiRegionAccessPointPolicyRequest getMultiRegionAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getMultiRegionAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPointPolicy");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getMultiRegionAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"getMultiRegionAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", getMultiRegionAccessPointPolicyRequest.accountId());
            GetMultiRegionAccessPointPolicyResponse getMultiRegionAccessPointPolicyResponse = (GetMultiRegionAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getMultiRegionAccessPointPolicyRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new GetMultiRegionAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return getMultiRegionAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getMultiRegionAccessPointPolicy$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMultiRegionAccessPointPolicyStatusResponse getMultiRegionAccessPointPolicyStatus(GetMultiRegionAccessPointPolicyStatusRequest getMultiRegionAccessPointPolicyStatusRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getMultiRegionAccessPointPolicyStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPointPolicyStatus");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getMultiRegionAccessPointPolicyStatusRequest.accountId(), (String)"AccountId", (String)"getMultiRegionAccessPointPolicyStatusRequest");
            String resolvedHostExpression = String.format("%s.", getMultiRegionAccessPointPolicyStatusRequest.accountId());
            GetMultiRegionAccessPointPolicyStatusResponse getMultiRegionAccessPointPolicyStatusResponse = (GetMultiRegionAccessPointPolicyStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPointPolicyStatus").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getMultiRegionAccessPointPolicyStatusRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new GetMultiRegionAccessPointPolicyStatusRequestMarshaller(this.protocolFactory)));
            return getMultiRegionAccessPointPolicyStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getMultiRegionAccessPointPolicyStatus$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPublicAccessBlockResponse getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) throws NoSuchPublicAccessBlockConfigurationException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicAccessBlock");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getPublicAccessBlockRequest.accountId(), (String)"AccountId", (String)"getPublicAccessBlockRequest");
            String resolvedHostExpression = String.format("%s.", getPublicAccessBlockRequest.accountId());
            GetPublicAccessBlockResponse getPublicAccessBlockResponse = (GetPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicAccessBlock").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getPublicAccessBlockRequest).withMarshaller((Marshaller)new GetPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return getPublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getPublicAccessBlock$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStorageLensConfigurationResponse getStorageLensConfiguration(GetStorageLensConfigurationRequest getStorageLensConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStorageLensConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStorageLensConfiguration");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getStorageLensConfigurationRequest.accountId(), (String)"AccountId", (String)"getStorageLensConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", getStorageLensConfigurationRequest.accountId());
            GetStorageLensConfigurationResponse getStorageLensConfigurationResponse = (GetStorageLensConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStorageLensConfiguration").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getStorageLensConfigurationRequest).withMarshaller((Marshaller)new GetStorageLensConfigurationRequestMarshaller(this.protocolFactory)));
            return getStorageLensConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getStorageLensConfiguration$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStorageLensConfigurationTaggingResponse getStorageLensConfigurationTagging(GetStorageLensConfigurationTaggingRequest getStorageLensConfigurationTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStorageLensConfigurationTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStorageLensConfigurationTagging");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getStorageLensConfigurationTaggingRequest.accountId(), (String)"AccountId", (String)"getStorageLensConfigurationTaggingRequest");
            String resolvedHostExpression = String.format("%s.", getStorageLensConfigurationTaggingRequest.accountId());
            GetStorageLensConfigurationTaggingResponse getStorageLensConfigurationTaggingResponse = (GetStorageLensConfigurationTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStorageLensConfigurationTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getStorageLensConfigurationTaggingRequest).withMarshaller((Marshaller)new GetStorageLensConfigurationTaggingRequestMarshaller(this.protocolFactory)));
            return getStorageLensConfigurationTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$getStorageLensConfigurationTagging$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccessPointsResponse listAccessPoints(ListAccessPointsRequest listAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListAccessPointsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listAccessPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPoints");
            String bucket = listAccessPointsRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = listAccessPointsRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                listAccessPointsRequest = (ListAccessPointsRequest)((Object)listAccessPointsRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listAccessPointsRequest.accountId(), (String)"AccountId", (String)"listAccessPointsRequest");
            String resolvedHostExpression = String.format("%s.", listAccessPointsRequest.accountId());
            ListAccessPointsResponse listAccessPointsResponse = (ListAccessPointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPoints").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listAccessPointsRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new ListAccessPointsRequestMarshaller(this.protocolFactory)));
            return listAccessPointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listAccessPoints$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAccessPointsIterable listAccessPointsPaginator(ListAccessPointsRequest listAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return new ListAccessPointsIterable(this, this.applyPaginatorUserAgent(listAccessPointsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccessPointsForObjectLambdaResponse listAccessPointsForObjectLambda(ListAccessPointsForObjectLambdaRequest listAccessPointsForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListAccessPointsForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listAccessPointsForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPointsForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listAccessPointsForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"listAccessPointsForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", listAccessPointsForObjectLambdaRequest.accountId());
            ListAccessPointsForObjectLambdaResponse listAccessPointsForObjectLambdaResponse = (ListAccessPointsForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPointsForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listAccessPointsForObjectLambdaRequest).withMarshaller((Marshaller)new ListAccessPointsForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return listAccessPointsForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listAccessPointsForObjectLambda$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAccessPointsForObjectLambdaIterable listAccessPointsForObjectLambdaPaginator(ListAccessPointsForObjectLambdaRequest listAccessPointsForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return new ListAccessPointsForObjectLambdaIterable(this, this.applyPaginatorUserAgent(listAccessPointsForObjectLambdaRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListJobsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listJobsRequest.accountId(), (String)"AccountId", (String)"listJobsRequest");
            String resolvedHostExpression = String.format("%s.", listJobsRequest.accountId());
            ListJobsResponse listJobsResponse = (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listJobsRequest).withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)));
            return listJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listJobs$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        return new ListJobsIterable(this, this.applyPaginatorUserAgent(listJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultiRegionAccessPointsResponse listMultiRegionAccessPoints(ListMultiRegionAccessPointsRequest listMultiRegionAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListMultiRegionAccessPointsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listMultiRegionAccessPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMultiRegionAccessPoints");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listMultiRegionAccessPointsRequest.accountId(), (String)"AccountId", (String)"listMultiRegionAccessPointsRequest");
            String resolvedHostExpression = String.format("%s.", listMultiRegionAccessPointsRequest.accountId());
            ListMultiRegionAccessPointsResponse listMultiRegionAccessPointsResponse = (ListMultiRegionAccessPointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultiRegionAccessPoints").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listMultiRegionAccessPointsRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new ListMultiRegionAccessPointsRequestMarshaller(this.protocolFactory)));
            return listMultiRegionAccessPointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listMultiRegionAccessPoints$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMultiRegionAccessPointsIterable listMultiRegionAccessPointsPaginator(ListMultiRegionAccessPointsRequest listMultiRegionAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return new ListMultiRegionAccessPointsIterable(this, this.applyPaginatorUserAgent(listMultiRegionAccessPointsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRegionalBucketsResponse listRegionalBuckets(ListRegionalBucketsRequest listRegionalBucketsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListRegionalBucketsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listRegionalBucketsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRegionalBuckets");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listRegionalBucketsRequest.accountId(), (String)"AccountId", (String)"listRegionalBucketsRequest");
            String resolvedHostExpression = String.format("%s.", listRegionalBucketsRequest.accountId());
            ListRegionalBucketsResponse listRegionalBucketsResponse = (ListRegionalBucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRegionalBuckets").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listRegionalBucketsRequest).withMarshaller((Marshaller)new ListRegionalBucketsRequestMarshaller(this.protocolFactory)));
            return listRegionalBucketsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listRegionalBuckets$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRegionalBucketsIterable listRegionalBucketsPaginator(ListRegionalBucketsRequest listRegionalBucketsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return new ListRegionalBucketsIterable(this, this.applyPaginatorUserAgent(listRegionalBucketsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStorageLensConfigurationsResponse listStorageLensConfigurations(ListStorageLensConfigurationsRequest listStorageLensConfigurationsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListStorageLensConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listStorageLensConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStorageLensConfigurations");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listStorageLensConfigurationsRequest.accountId(), (String)"AccountId", (String)"listStorageLensConfigurationsRequest");
            String resolvedHostExpression = String.format("%s.", listStorageLensConfigurationsRequest.accountId());
            ListStorageLensConfigurationsResponse listStorageLensConfigurationsResponse = (ListStorageLensConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStorageLensConfigurations").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listStorageLensConfigurationsRequest).withMarshaller((Marshaller)new ListStorageLensConfigurationsRequestMarshaller(this.protocolFactory)));
            return listStorageLensConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$listStorageLensConfigurations$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListStorageLensConfigurationsIterable listStorageLensConfigurationsPaginator(ListStorageLensConfigurationsRequest listStorageLensConfigurationsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return new ListStorageLensConfigurationsIterable(this, this.applyPaginatorUserAgent(listStorageLensConfigurationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccessPointConfigurationForObjectLambdaResponse putAccessPointConfigurationForObjectLambda(PutAccessPointConfigurationForObjectLambdaRequest putAccessPointConfigurationForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointConfigurationForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putAccessPointConfigurationForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointConfigurationForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putAccessPointConfigurationForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"putAccessPointConfigurationForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", putAccessPointConfigurationForObjectLambdaRequest.accountId());
            PutAccessPointConfigurationForObjectLambdaResponse putAccessPointConfigurationForObjectLambdaResponse = (PutAccessPointConfigurationForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointConfigurationForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putAccessPointConfigurationForObjectLambdaRequest).withMarshaller((Marshaller)new PutAccessPointConfigurationForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return putAccessPointConfigurationForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putAccessPointConfigurationForObjectLambda$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccessPointPolicyResponse putAccessPointPolicy(PutAccessPointPolicyRequest putAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointPolicy");
            String name = putAccessPointPolicyRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = putAccessPointPolicyRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putAccessPointPolicyRequest = (PutAccessPointPolicyRequest)((Object)putAccessPointPolicyRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"putAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", putAccessPointPolicyRequest.accountId());
            PutAccessPointPolicyResponse putAccessPointPolicyResponse = (PutAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putAccessPointPolicyRequest).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new PutAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return putAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putAccessPointPolicy$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccessPointPolicyForObjectLambdaResponse putAccessPointPolicyForObjectLambda(PutAccessPointPolicyForObjectLambdaRequest putAccessPointPolicyForObjectLambdaRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointPolicyForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointPolicyForObjectLambda");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putAccessPointPolicyForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"putAccessPointPolicyForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", putAccessPointPolicyForObjectLambdaRequest.accountId());
            PutAccessPointPolicyForObjectLambdaResponse putAccessPointPolicyForObjectLambdaResponse = (PutAccessPointPolicyForObjectLambdaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointPolicyForObjectLambda").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putAccessPointPolicyForObjectLambdaRequest).withMarshaller((Marshaller)new PutAccessPointPolicyForObjectLambdaRequestMarshaller(this.protocolFactory)));
            return putAccessPointPolicyForObjectLambdaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putAccessPointPolicyForObjectLambda$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketLifecycleConfigurationResponse putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketLifecycleConfiguration");
            String bucket = putBucketLifecycleConfigurationRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = putBucketLifecycleConfigurationRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putBucketLifecycleConfigurationRequest = (PutBucketLifecycleConfigurationRequest)((Object)putBucketLifecycleConfigurationRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putBucketLifecycleConfigurationRequest.accountId(), (String)"AccountId", (String)"putBucketLifecycleConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", putBucketLifecycleConfigurationRequest.accountId());
            PutBucketLifecycleConfigurationResponse putBucketLifecycleConfigurationResponse = (PutBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLifecycleConfiguration").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putBucketLifecycleConfigurationRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new PutBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)));
            return putBucketLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketLifecycleConfiguration$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketPolicyResponse putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketPolicy");
            String bucket = putBucketPolicyRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = putBucketPolicyRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putBucketPolicyRequest = (PutBucketPolicyRequest)((Object)putBucketPolicyRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putBucketPolicyRequest.accountId(), (String)"AccountId", (String)"putBucketPolicyRequest");
            String resolvedHostExpression = String.format("%s.", putBucketPolicyRequest.accountId());
            PutBucketPolicyResponse putBucketPolicyResponse = (PutBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putBucketPolicyRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new PutBucketPolicyRequestMarshaller(this.protocolFactory)));
            return putBucketPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketPolicy$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBucketTaggingResponse putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketTagging");
            String bucket = putBucketTaggingRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = putBucketTaggingRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putBucketTaggingRequest = (PutBucketTaggingRequest)((Object)putBucketTaggingRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putBucketTaggingRequest.accountId(), (String)"AccountId", (String)"putBucketTaggingRequest");
            String resolvedHostExpression = String.format("%s.", putBucketTaggingRequest.accountId());
            PutBucketTaggingResponse putBucketTaggingResponse = (PutBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putBucketTaggingRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withMarshaller((Marshaller)new PutBucketTaggingRequestMarshaller(this.protocolFactory)));
            return putBucketTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putBucketTagging$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutJobTaggingResponse putJobTagging(PutJobTaggingRequest putJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobTagging");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putJobTaggingRequest.accountId(), (String)"AccountId", (String)"putJobTaggingRequest");
            String resolvedHostExpression = String.format("%s.", putJobTaggingRequest.accountId());
            PutJobTaggingResponse putJobTaggingResponse = (PutJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putJobTaggingRequest).withMarshaller((Marshaller)new PutJobTaggingRequestMarshaller(this.protocolFactory)));
            return putJobTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putJobTagging$68((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutMultiRegionAccessPointPolicyResponse putMultiRegionAccessPointPolicy(PutMultiRegionAccessPointPolicyRequest putMultiRegionAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutMultiRegionAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putMultiRegionAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMultiRegionAccessPointPolicy");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putMultiRegionAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"putMultiRegionAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", putMultiRegionAccessPointPolicyRequest.accountId());
            PutMultiRegionAccessPointPolicyResponse putMultiRegionAccessPointPolicyResponse = (PutMultiRegionAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMultiRegionAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putMultiRegionAccessPointPolicyRequest).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withMarshaller((Marshaller)new PutMultiRegionAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return putMultiRegionAccessPointPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putMultiRegionAccessPointPolicy$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPublicAccessBlockResponse putPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPublicAccessBlock");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putPublicAccessBlockRequest.accountId(), (String)"AccountId", (String)"putPublicAccessBlockRequest");
            String resolvedHostExpression = String.format("%s.", putPublicAccessBlockRequest.accountId());
            PutPublicAccessBlockResponse putPublicAccessBlockResponse = (PutPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPublicAccessBlock").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putPublicAccessBlockRequest).withMarshaller((Marshaller)new PutPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return putPublicAccessBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putPublicAccessBlock$70((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutStorageLensConfigurationResponse putStorageLensConfiguration(PutStorageLensConfigurationRequest putStorageLensConfigurationRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutStorageLensConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutStorageLensConfiguration");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putStorageLensConfigurationRequest.accountId(), (String)"AccountId", (String)"putStorageLensConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", putStorageLensConfigurationRequest.accountId());
            PutStorageLensConfigurationResponse putStorageLensConfigurationResponse = (PutStorageLensConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutStorageLensConfiguration").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putStorageLensConfigurationRequest).withMarshaller((Marshaller)new PutStorageLensConfigurationRequestMarshaller(this.protocolFactory)));
            return putStorageLensConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putStorageLensConfiguration$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutStorageLensConfigurationTaggingResponse putStorageLensConfigurationTagging(PutStorageLensConfigurationTaggingRequest putStorageLensConfigurationTaggingRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutStorageLensConfigurationTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutStorageLensConfigurationTagging");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putStorageLensConfigurationTaggingRequest.accountId(), (String)"AccountId", (String)"putStorageLensConfigurationTaggingRequest");
            String resolvedHostExpression = String.format("%s.", putStorageLensConfigurationTaggingRequest.accountId());
            PutStorageLensConfigurationTaggingResponse putStorageLensConfigurationTaggingResponse = (PutStorageLensConfigurationTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutStorageLensConfigurationTagging").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)putStorageLensConfigurationTaggingRequest).withMarshaller((Marshaller)new PutStorageLensConfigurationTaggingRequestMarshaller(this.protocolFactory)));
            return putStorageLensConfigurationTaggingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$putStorageLensConfigurationTagging$72((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobPriorityResponse updateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobPriorityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, updateJobPriorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobPriority");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)updateJobPriorityRequest.accountId(), (String)"AccountId", (String)"updateJobPriorityRequest");
            String resolvedHostExpression = String.format("%s.", updateJobPriorityRequest.accountId());
            UpdateJobPriorityResponse updateJobPriorityResponse = (UpdateJobPriorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobPriority").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateJobPriorityRequest).withMarshaller((Marshaller)new UpdateJobPriorityRequestMarshaller(this.protocolFactory)));
            return updateJobPriorityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$updateJobPriority$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobStatusResponse updateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, JobStatusException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, updateJobStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobStatus");
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)updateJobStatusRequest.accountId(), (String)"AccountId", (String)"updateJobStatusRequest");
            String resolvedHostExpression = String.format("%s.", updateJobStatusRequest.accountId());
            UpdateJobStatusResponse updateJobStatusResponse = (UpdateJobStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobStatus").withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateJobStatusRequest).withMarshaller((Marshaller)new UpdateJobStatusRequestMarshaller(this.protocolFactory)));
            return updateJobStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlClient.lambda$updateJobStatus$74((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("JobStatusException").exceptionBuilderSupplier(JobStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchPublicAccessBlockConfiguration").exceptionBuilderSupplier(NoSuchPublicAccessBlockConfigurationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyExists").exceptionBuilderSupplier(BucketAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotencyException").exceptionBuilderSupplier(IdempotencyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyOwnedByYou").exceptionBuilderSupplier(BucketAlreadyOwnedByYouException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(S3ControlException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends S3ControlRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.121").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((S3ControlRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateJobStatus$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJobPriority$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putStorageLensConfigurationTagging$72(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putStorageLensConfiguration$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPublicAccessBlock$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMultiRegionAccessPointPolicy$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobTagging$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketTagging$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketPolicy$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketLifecycleConfiguration$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointPolicyForObjectLambda$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointPolicy$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointConfigurationForObjectLambda$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStorageLensConfigurations$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRegionalBuckets$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMultiRegionAccessPoints$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobs$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessPointsForObjectLambda$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessPoints$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStorageLensConfigurationTagging$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStorageLensConfiguration$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicAccessBlock$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPointPolicyStatus$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPointPolicy$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPoint$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobTagging$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketTagging$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketPolicy$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketLifecycleConfiguration$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucket$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyStatusForObjectLambda$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyStatus$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyForObjectLambda$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicy$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointForObjectLambda$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointConfigurationForObjectLambda$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPoint$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiRegionAccessPointOperation$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJob$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStorageLensConfigurationTagging$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStorageLensConfiguration$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePublicAccessBlock$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMultiRegionAccessPoint$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJobTagging$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketTagging$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketPolicy$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketLifecycleConfiguration$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucket$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointPolicyForObjectLambda$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointPolicy$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointForObjectLambda$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPoint$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMultiRegionAccessPoint$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJob$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucket$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPointForObjectLambda$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPoint$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

