/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeature;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaAllowedFeaturesListCopier;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfiguration;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectLambdaConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectLambdaConfiguration> {
    private static final SdkField<String> SUPPORTING_ACCESS_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportingAccessPoint").getter(ObjectLambdaConfiguration.getter(ObjectLambdaConfiguration::supportingAccessPoint)).setter(ObjectLambdaConfiguration.setter(Builder::supportingAccessPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportingAccessPoint").unmarshallLocationName("SupportingAccessPoint").build()}).build();
    private static final SdkField<Boolean> CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CloudWatchMetricsEnabled").getter(ObjectLambdaConfiguration.getter(ObjectLambdaConfiguration::cloudWatchMetricsEnabled)).setter(ObjectLambdaConfiguration.setter(Builder::cloudWatchMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetricsEnabled").unmarshallLocationName("CloudWatchMetricsEnabled").build()}).build();
    private static final SdkField<List<String>> ALLOWED_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedFeatures").getter(ObjectLambdaConfiguration.getter(ObjectLambdaConfiguration::allowedFeaturesAsStrings)).setter(ObjectLambdaConfiguration.setter(Builder::allowedFeaturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedFeatures").unmarshallLocationName("AllowedFeatures").build(), ListTrait.builder().memberLocationName("AllowedFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedFeature").unmarshallLocationName("AllowedFeature").build()}).build()).build()}).build();
    private static final SdkField<List<ObjectLambdaTransformationConfiguration>> TRANSFORMATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransformationConfigurations").getter(ObjectLambdaConfiguration.getter(ObjectLambdaConfiguration::transformationConfigurations)).setter(ObjectLambdaConfiguration.setter(Builder::transformationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformationConfigurations").unmarshallLocationName("TransformationConfigurations").build(), ListTrait.builder().memberLocationName("TransformationConfiguration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectLambdaTransformationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformationConfiguration").unmarshallLocationName("TransformationConfiguration").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTING_ACCESS_POINT_FIELD, CLOUD_WATCH_METRICS_ENABLED_FIELD, ALLOWED_FEATURES_FIELD, TRANSFORMATION_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String supportingAccessPoint;
    private final Boolean cloudWatchMetricsEnabled;
    private final List<String> allowedFeatures;
    private final List<ObjectLambdaTransformationConfiguration> transformationConfigurations;

    private ObjectLambdaConfiguration(BuilderImpl builder) {
        this.supportingAccessPoint = builder.supportingAccessPoint;
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.allowedFeatures = builder.allowedFeatures;
        this.transformationConfigurations = builder.transformationConfigurations;
    }

    public final String supportingAccessPoint() {
        return this.supportingAccessPoint;
    }

    public final Boolean cloudWatchMetricsEnabled() {
        return this.cloudWatchMetricsEnabled;
    }

    public final List<ObjectLambdaAllowedFeature> allowedFeatures() {
        return ObjectLambdaAllowedFeaturesListCopier.copyStringToEnum(this.allowedFeatures);
    }

    public final boolean hasAllowedFeatures() {
        return this.allowedFeatures != null && !(this.allowedFeatures instanceof SdkAutoConstructList);
    }

    public final List<String> allowedFeaturesAsStrings() {
        return this.allowedFeatures;
    }

    public final boolean hasTransformationConfigurations() {
        return this.transformationConfigurations != null && !(this.transformationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ObjectLambdaTransformationConfiguration> transformationConfigurations() {
        return this.transformationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.supportingAccessPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedFeatures() ? this.allowedFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformationConfigurations() ? this.transformationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLambdaConfiguration)) {
            return false;
        }
        ObjectLambdaConfiguration other = (ObjectLambdaConfiguration)obj;
        return Objects.equals(this.supportingAccessPoint(), other.supportingAccessPoint()) && Objects.equals(this.cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled()) && this.hasAllowedFeatures() == other.hasAllowedFeatures() && Objects.equals(this.allowedFeaturesAsStrings(), other.allowedFeaturesAsStrings()) && this.hasTransformationConfigurations() == other.hasTransformationConfigurations() && Objects.equals(this.transformationConfigurations(), other.transformationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ObjectLambdaConfiguration").add("SupportingAccessPoint", (Object)this.supportingAccessPoint()).add("CloudWatchMetricsEnabled", (Object)this.cloudWatchMetricsEnabled()).add("AllowedFeatures", this.hasAllowedFeatures() ? this.allowedFeaturesAsStrings() : null).add("TransformationConfigurations", this.hasTransformationConfigurations() ? this.transformationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SupportingAccessPoint": {
                return Optional.ofNullable(clazz.cast(this.supportingAccessPoint()));
            }
            case "CloudWatchMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMetricsEnabled()));
            }
            case "AllowedFeatures": {
                return Optional.ofNullable(clazz.cast(this.allowedFeaturesAsStrings()));
            }
            case "TransformationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.transformationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectLambdaConfiguration, T> g) {
        return obj -> g.apply((ObjectLambdaConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String supportingAccessPoint;
        private Boolean cloudWatchMetricsEnabled;
        private List<String> allowedFeatures = DefaultSdkAutoConstructList.getInstance();
        private List<ObjectLambdaTransformationConfiguration> transformationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectLambdaConfiguration model) {
            this.supportingAccessPoint(model.supportingAccessPoint);
            this.cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            this.allowedFeaturesWithStrings(model.allowedFeatures);
            this.transformationConfigurations(model.transformationConfigurations);
        }

        public final String getSupportingAccessPoint() {
            return this.supportingAccessPoint;
        }

        @Override
        public final Builder supportingAccessPoint(String supportingAccessPoint) {
            this.supportingAccessPoint = supportingAccessPoint;
            return this;
        }

        public final void setSupportingAccessPoint(String supportingAccessPoint) {
            this.supportingAccessPoint = supportingAccessPoint;
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return this.cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        public final Collection<String> getAllowedFeatures() {
            if (this.allowedFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedFeatures;
        }

        @Override
        public final Builder allowedFeaturesWithStrings(Collection<String> allowedFeatures) {
            this.allowedFeatures = ObjectLambdaAllowedFeaturesListCopier.copy(allowedFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFeaturesWithStrings(String ... allowedFeatures) {
            this.allowedFeaturesWithStrings(Arrays.asList(allowedFeatures));
            return this;
        }

        @Override
        public final Builder allowedFeatures(Collection<ObjectLambdaAllowedFeature> allowedFeatures) {
            this.allowedFeatures = ObjectLambdaAllowedFeaturesListCopier.copyEnumToString(allowedFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedFeatures(ObjectLambdaAllowedFeature ... allowedFeatures) {
            this.allowedFeatures(Arrays.asList(allowedFeatures));
            return this;
        }

        public final void setAllowedFeatures(Collection<String> allowedFeatures) {
            this.allowedFeatures = ObjectLambdaAllowedFeaturesListCopier.copy(allowedFeatures);
        }

        public final List<ObjectLambdaTransformationConfiguration.Builder> getTransformationConfigurations() {
            List<ObjectLambdaTransformationConfiguration.Builder> result = ObjectLambdaTransformationConfigurationsListCopier.copyToBuilder(this.transformationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder transformationConfigurations(Collection<ObjectLambdaTransformationConfiguration> transformationConfigurations) {
            this.transformationConfigurations = ObjectLambdaTransformationConfigurationsListCopier.copy(transformationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformationConfigurations(ObjectLambdaTransformationConfiguration ... transformationConfigurations) {
            this.transformationConfigurations(Arrays.asList(transformationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformationConfigurations(Consumer<ObjectLambdaTransformationConfiguration.Builder> ... transformationConfigurations) {
            this.transformationConfigurations(Stream.of(transformationConfigurations).map(c -> (ObjectLambdaTransformationConfiguration)((ObjectLambdaTransformationConfiguration.Builder)ObjectLambdaTransformationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransformationConfigurations(Collection<ObjectLambdaTransformationConfiguration.BuilderImpl> transformationConfigurations) {
            this.transformationConfigurations = ObjectLambdaTransformationConfigurationsListCopier.copyFromBuilder(transformationConfigurations);
        }

        public ObjectLambdaConfiguration build() {
            return new ObjectLambdaConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectLambdaConfiguration> {
        public Builder supportingAccessPoint(String var1);

        public Builder cloudWatchMetricsEnabled(Boolean var1);

        public Builder allowedFeaturesWithStrings(Collection<String> var1);

        public Builder allowedFeaturesWithStrings(String ... var1);

        public Builder allowedFeatures(Collection<ObjectLambdaAllowedFeature> var1);

        public Builder allowedFeatures(ObjectLambdaAllowedFeature ... var1);

        public Builder transformationConfigurations(Collection<ObjectLambdaTransformationConfiguration> var1);

        public Builder transformationConfigurations(ObjectLambdaTransformationConfiguration ... var1);

        public Builder transformationConfigurations(Consumer<ObjectLambdaTransformationConfiguration.Builder> ... var1);
    }
}

