/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.JobManifestFieldListCopier;
import software.amazon.awssdk.services.s3control.model.JobManifestFieldName;
import software.amazon.awssdk.services.s3control.model.JobManifestFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobManifestSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobManifestSpec> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(JobManifestSpec.getter(JobManifestSpec::formatAsString)).setter(JobManifestSpec.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").unmarshallLocationName("Format").build()}).build();
    private static final SdkField<List<String>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(JobManifestSpec.getter(JobManifestSpec::fieldsAsStrings)).setter(JobManifestSpec.setter(Builder::fieldsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").unmarshallLocationName("Fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, FIELDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final List<String> fields;

    private JobManifestSpec(BuilderImpl builder) {
        this.format = builder.format;
        this.fields = builder.fields;
    }

    public JobManifestFormat format() {
        return JobManifestFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public List<JobManifestFieldName> fields() {
        return JobManifestFieldListCopier.copyStringToEnum(this.fields);
    }

    public boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public List<String> fieldsAsStrings() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fieldsAsStrings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobManifestSpec)) {
            return false;
        }
        JobManifestSpec other = (JobManifestSpec)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && this.hasFields() == other.hasFields() && Objects.equals(this.fieldsAsStrings(), other.fieldsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"JobManifestSpec").add("Format", (Object)this.formatAsString()).add("Fields", this.hasFields() ? this.fieldsAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fieldsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobManifestSpec, T> g) {
        return obj -> g.apply((JobManifestSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private List<String> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobManifestSpec model) {
            this.format(model.format);
            this.fieldsWithStrings(model.fields);
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(JobManifestFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Collection<String> getFields() {
            if (this.fields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fields;
        }

        @Override
        public final Builder fieldsWithStrings(Collection<String> fields) {
            this.fields = JobManifestFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsWithStrings(String ... fields) {
            this.fieldsWithStrings(Arrays.asList(fields));
            return this;
        }

        @Override
        public final Builder fields(Collection<JobManifestFieldName> fields) {
            this.fields = JobManifestFieldListCopier.copyEnumToString(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(JobManifestFieldName ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        public final void setFields(Collection<String> fields) {
            this.fields = JobManifestFieldListCopier.copy(fields);
        }

        public JobManifestSpec build() {
            return new JobManifestSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobManifestSpec> {
        public Builder format(String var1);

        public Builder format(JobManifestFormat var1);

        public Builder fieldsWithStrings(Collection<String> var1);

        public Builder fieldsWithStrings(String ... var1);

        public Builder fields(Collection<JobManifestFieldName> var1);

        public Builder fields(JobManifestFieldName ... var1);
    }
}

