/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NetworkOrigin {
    INTERNET("Internet"),
    VPC("VPC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NetworkOrigin(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkOrigin fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NetworkOrigin.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkOrigin> knownValues() {
        return Stream.of(NetworkOrigin.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

