/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3AccessControlList;
import software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3AccessControlPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3AccessControlPolicy> {
    private static final SdkField<S3AccessControlList> ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessControlList").getter(S3AccessControlPolicy.getter(S3AccessControlPolicy::accessControlList)).setter(S3AccessControlPolicy.setter(Builder::accessControlList)).constructor(S3AccessControlList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList").unmarshallLocationName("AccessControlList").build()}).build();
    private static final SdkField<String> CANNED_ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CannedAccessControlList").getter(S3AccessControlPolicy.getter(S3AccessControlPolicy::cannedAccessControlListAsString)).setter(S3AccessControlPolicy.setter(Builder::cannedAccessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CannedAccessControlList").unmarshallLocationName("CannedAccessControlList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_LIST_FIELD, CANNED_ACCESS_CONTROL_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3AccessControlList accessControlList;
    private final String cannedAccessControlList;

    private S3AccessControlPolicy(BuilderImpl builder) {
        this.accessControlList = builder.accessControlList;
        this.cannedAccessControlList = builder.cannedAccessControlList;
    }

    public S3AccessControlList accessControlList() {
        return this.accessControlList;
    }

    public S3CannedAccessControlList cannedAccessControlList() {
        return S3CannedAccessControlList.fromValue(this.cannedAccessControlList);
    }

    public String cannedAccessControlListAsString() {
        return this.cannedAccessControlList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControlList());
        hashCode = 31 * hashCode + Objects.hashCode(this.cannedAccessControlListAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessControlPolicy)) {
            return false;
        }
        S3AccessControlPolicy other = (S3AccessControlPolicy)obj;
        return Objects.equals(this.accessControlList(), other.accessControlList()) && Objects.equals(this.cannedAccessControlListAsString(), other.cannedAccessControlListAsString());
    }

    public String toString() {
        return ToString.builder((String)"S3AccessControlPolicy").add("AccessControlList", (Object)this.accessControlList()).add("CannedAccessControlList", (Object)this.cannedAccessControlListAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessControlList": {
                return Optional.ofNullable(clazz.cast(this.accessControlList()));
            }
            case "CannedAccessControlList": {
                return Optional.ofNullable(clazz.cast(this.cannedAccessControlListAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3AccessControlPolicy, T> g) {
        return obj -> g.apply((S3AccessControlPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3AccessControlList accessControlList;
        private String cannedAccessControlList;

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessControlPolicy model) {
            this.accessControlList(model.accessControlList);
            this.cannedAccessControlList(model.cannedAccessControlList);
        }

        public final S3AccessControlList.Builder getAccessControlList() {
            return this.accessControlList != null ? this.accessControlList.toBuilder() : null;
        }

        @Override
        public final Builder accessControlList(S3AccessControlList accessControlList) {
            this.accessControlList = accessControlList;
            return this;
        }

        public final void setAccessControlList(S3AccessControlList.BuilderImpl accessControlList) {
            this.accessControlList = accessControlList != null ? accessControlList.build() : null;
        }

        public final String getCannedAccessControlList() {
            return this.cannedAccessControlList;
        }

        @Override
        public final Builder cannedAccessControlList(String cannedAccessControlList) {
            this.cannedAccessControlList = cannedAccessControlList;
            return this;
        }

        @Override
        public final Builder cannedAccessControlList(S3CannedAccessControlList cannedAccessControlList) {
            this.cannedAccessControlList(cannedAccessControlList == null ? null : cannedAccessControlList.toString());
            return this;
        }

        public final void setCannedAccessControlList(String cannedAccessControlList) {
            this.cannedAccessControlList = cannedAccessControlList;
        }

        public S3AccessControlPolicy build() {
            return new S3AccessControlPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3AccessControlPolicy> {
        public Builder accessControlList(S3AccessControlList var1);

        default public Builder accessControlList(Consumer<S3AccessControlList.Builder> accessControlList) {
            return this.accessControlList((S3AccessControlList)((S3AccessControlList.Builder)S3AccessControlList.builder().applyMutation(accessControlList)).build());
        }

        public Builder cannedAccessControlList(String var1);

        public Builder cannedAccessControlList(S3CannedAccessControlList var1);
    }
}

