/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm;
import software.amazon.awssdk.services.s3control.model.S3UserMetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ObjectMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ObjectMetadata> {
    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheControl").getter(S3ObjectMetadata.getter(S3ObjectMetadata::cacheControl)).setter(S3ObjectMetadata.setter(Builder::cacheControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheControl").unmarshallLocationName("CacheControl").build()}).build();
    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentDisposition").getter(S3ObjectMetadata.getter(S3ObjectMetadata::contentDisposition)).setter(S3ObjectMetadata.setter(Builder::contentDisposition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentDisposition").unmarshallLocationName("ContentDisposition").build()}).build();
    private static final SdkField<String> CONTENT_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentEncoding").getter(S3ObjectMetadata.getter(S3ObjectMetadata::contentEncoding)).setter(S3ObjectMetadata.setter(Builder::contentEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentEncoding").unmarshallLocationName("ContentEncoding").build()}).build();
    private static final SdkField<String> CONTENT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentLanguage").getter(S3ObjectMetadata.getter(S3ObjectMetadata::contentLanguage)).setter(S3ObjectMetadata.setter(Builder::contentLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentLanguage").unmarshallLocationName("ContentLanguage").build()}).build();
    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserMetadata").getter(S3ObjectMetadata.getter(S3ObjectMetadata::userMetadata)).setter(S3ObjectMetadata.setter(Builder::userMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMetadata").unmarshallLocationName("UserMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").unmarshallLocationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ContentLength").getter(S3ObjectMetadata.getter(S3ObjectMetadata::contentLength)).setter(S3ObjectMetadata.setter(Builder::contentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentLength").unmarshallLocationName("ContentLength").build()}).build();
    private static final SdkField<String> CONTENT_MD5_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentMD5").getter(S3ObjectMetadata.getter(S3ObjectMetadata::contentMD5)).setter(S3ObjectMetadata.setter(Builder::contentMD5)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentMD5").unmarshallLocationName("ContentMD5").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(S3ObjectMetadata.getter(S3ObjectMetadata::contentType)).setter(S3ObjectMetadata.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").unmarshallLocationName("ContentType").build()}).build();
    private static final SdkField<Instant> HTTP_EXPIRES_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("HttpExpiresDate").getter(S3ObjectMetadata.getter(S3ObjectMetadata::httpExpiresDate)).setter(S3ObjectMetadata.setter(Builder::httpExpiresDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpExpiresDate").unmarshallLocationName("HttpExpiresDate").build()}).build();
    private static final SdkField<Boolean> REQUESTER_CHARGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequesterCharged").getter(S3ObjectMetadata.getter(S3ObjectMetadata::requesterCharged)).setter(S3ObjectMetadata.setter(Builder::requesterCharged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterCharged").unmarshallLocationName("RequesterCharged").build()}).build();
    private static final SdkField<String> SSE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SSEAlgorithm").getter(S3ObjectMetadata.getter(S3ObjectMetadata::sseAlgorithmAsString)).setter(S3ObjectMetadata.setter(Builder::sseAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEAlgorithm").unmarshallLocationName("SSEAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CONTROL_FIELD, CONTENT_DISPOSITION_FIELD, CONTENT_ENCODING_FIELD, CONTENT_LANGUAGE_FIELD, USER_METADATA_FIELD, CONTENT_LENGTH_FIELD, CONTENT_MD5_FIELD, CONTENT_TYPE_FIELD, HTTP_EXPIRES_DATE_FIELD, REQUESTER_CHARGED_FIELD, SSE_ALGORITHM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final Map<String, String> userMetadata;
    private final Long contentLength;
    private final String contentMD5;
    private final String contentType;
    private final Instant httpExpiresDate;
    private final Boolean requesterCharged;
    private final String sseAlgorithm;

    private S3ObjectMetadata(BuilderImpl builder) {
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.userMetadata = builder.userMetadata;
        this.contentLength = builder.contentLength;
        this.contentMD5 = builder.contentMD5;
        this.contentType = builder.contentType;
        this.httpExpiresDate = builder.httpExpiresDate;
        this.requesterCharged = builder.requesterCharged;
        this.sseAlgorithm = builder.sseAlgorithm;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public boolean hasUserMetadata() {
        return this.userMetadata != null && !(this.userMetadata instanceof SdkAutoConstructMap);
    }

    public Map<String, String> userMetadata() {
        return this.userMetadata;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String contentType() {
        return this.contentType;
    }

    public Instant httpExpiresDate() {
        return this.httpExpiresDate;
    }

    public Boolean requesterCharged() {
        return this.requesterCharged;
    }

    public S3SSEAlgorithm sseAlgorithm() {
        return S3SSEAlgorithm.fromValue(this.sseAlgorithm);
    }

    public String sseAlgorithmAsString() {
        return this.sseAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDisposition());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentEncoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserMetadata() ? this.userMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpExpiresDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterCharged());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseAlgorithmAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ObjectMetadata)) {
            return false;
        }
        S3ObjectMetadata other = (S3ObjectMetadata)obj;
        return Objects.equals(this.cacheControl(), other.cacheControl()) && Objects.equals(this.contentDisposition(), other.contentDisposition()) && Objects.equals(this.contentEncoding(), other.contentEncoding()) && Objects.equals(this.contentLanguage(), other.contentLanguage()) && this.hasUserMetadata() == other.hasUserMetadata() && Objects.equals(this.userMetadata(), other.userMetadata()) && Objects.equals(this.contentLength(), other.contentLength()) && Objects.equals(this.contentMD5(), other.contentMD5()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.httpExpiresDate(), other.httpExpiresDate()) && Objects.equals(this.requesterCharged(), other.requesterCharged()) && Objects.equals(this.sseAlgorithmAsString(), other.sseAlgorithmAsString());
    }

    public String toString() {
        return ToString.builder((String)"S3ObjectMetadata").add("CacheControl", (Object)this.cacheControl()).add("ContentDisposition", (Object)this.contentDisposition()).add("ContentEncoding", (Object)this.contentEncoding()).add("ContentLanguage", (Object)this.contentLanguage()).add("UserMetadata", this.hasUserMetadata() ? this.userMetadata() : null).add("ContentLength", (Object)this.contentLength()).add("ContentMD5", (Object)this.contentMD5()).add("ContentType", (Object)this.contentType()).add("HttpExpiresDate", (Object)this.httpExpiresDate()).add("RequesterCharged", (Object)this.requesterCharged()).add("SSEAlgorithm", (Object)this.sseAlgorithmAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheControl": {
                return Optional.ofNullable(clazz.cast(this.cacheControl()));
            }
            case "ContentDisposition": {
                return Optional.ofNullable(clazz.cast(this.contentDisposition()));
            }
            case "ContentEncoding": {
                return Optional.ofNullable(clazz.cast(this.contentEncoding()));
            }
            case "ContentLanguage": {
                return Optional.ofNullable(clazz.cast(this.contentLanguage()));
            }
            case "UserMetadata": {
                return Optional.ofNullable(clazz.cast(this.userMetadata()));
            }
            case "ContentLength": {
                return Optional.ofNullable(clazz.cast(this.contentLength()));
            }
            case "ContentMD5": {
                return Optional.ofNullable(clazz.cast(this.contentMD5()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "HttpExpiresDate": {
                return Optional.ofNullable(clazz.cast(this.httpExpiresDate()));
            }
            case "RequesterCharged": {
                return Optional.ofNullable(clazz.cast(this.requesterCharged()));
            }
            case "SSEAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.sseAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ObjectMetadata, T> g) {
        return obj -> g.apply((S3ObjectMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();
        private Long contentLength;
        private String contentMD5;
        private String contentType;
        private Instant httpExpiresDate;
        private Boolean requesterCharged;
        private String sseAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ObjectMetadata model) {
            this.cacheControl(model.cacheControl);
            this.contentDisposition(model.contentDisposition);
            this.contentEncoding(model.contentEncoding);
            this.contentLanguage(model.contentLanguage);
            this.userMetadata(model.userMetadata);
            this.contentLength(model.contentLength);
            this.contentMD5(model.contentMD5);
            this.contentType(model.contentType);
            this.httpExpiresDate(model.httpExpiresDate);
            this.requesterCharged(model.requesterCharged);
            this.sseAlgorithm(model.sseAlgorithm);
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public final String getContentLanguage() {
            return this.contentLanguage;
        }

        @Override
        public final Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public final void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        public final Map<String, String> getUserMetadata() {
            if (this.userMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = S3UserMetadataCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = S3UserMetadataCopier.copy(userMetadata);
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Instant getHttpExpiresDate() {
            return this.httpExpiresDate;
        }

        @Override
        public final Builder httpExpiresDate(Instant httpExpiresDate) {
            this.httpExpiresDate = httpExpiresDate;
            return this;
        }

        public final void setHttpExpiresDate(Instant httpExpiresDate) {
            this.httpExpiresDate = httpExpiresDate;
        }

        public final Boolean getRequesterCharged() {
            return this.requesterCharged;
        }

        @Override
        public final Builder requesterCharged(Boolean requesterCharged) {
            this.requesterCharged = requesterCharged;
            return this;
        }

        public final void setRequesterCharged(Boolean requesterCharged) {
            this.requesterCharged = requesterCharged;
        }

        public final String getSseAlgorithm() {
            return this.sseAlgorithm;
        }

        @Override
        public final Builder sseAlgorithm(String sseAlgorithm) {
            this.sseAlgorithm = sseAlgorithm;
            return this;
        }

        @Override
        public final Builder sseAlgorithm(S3SSEAlgorithm sseAlgorithm) {
            this.sseAlgorithm(sseAlgorithm == null ? null : sseAlgorithm.toString());
            return this;
        }

        public final void setSseAlgorithm(String sseAlgorithm) {
            this.sseAlgorithm = sseAlgorithm;
        }

        public S3ObjectMetadata build() {
            return new S3ObjectMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ObjectMetadata> {
        public Builder cacheControl(String var1);

        public Builder contentDisposition(String var1);

        public Builder contentEncoding(String var1);

        public Builder contentLanguage(String var1);

        public Builder userMetadata(Map<String, String> var1);

        public Builder contentLength(Long var1);

        public Builder contentMD5(String var1);

        public Builder contentType(String var1);

        public Builder httpExpiresDate(Instant var1);

        public Builder requesterCharged(Boolean var1);

        public Builder sseAlgorithm(String var1);

        public Builder sseAlgorithm(S3SSEAlgorithm var1);
    }
}

