/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.internal.interceptors;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3control.S3ControlConfiguration;
import software.amazon.awssdk.services.s3control.internal.ArnHandler;
import software.amazon.awssdk.services.s3control.internal.HandlerUtils;
import software.amazon.awssdk.services.s3control.internal.S3ArnableField;
import software.amazon.awssdk.services.s3control.internal.S3ControlInternalExecutionAttribute;
import software.amazon.awssdk.services.s3control.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class EndpointAddressInterceptor
implements ExecutionInterceptor {
    private final ArnHandler arnHandler = ArnHandler.getInstance();

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest request = context.httpRequest();
        S3ControlConfiguration config = (S3ControlConfiguration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
        S3ArnableField arnableField = (S3ArnableField)executionAttributes.getAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD);
        if (arnableField != null && arnableField.arn() != null) {
            return this.arnHandler.resolveHostForArn(request, config, arnableField.arn(), executionAttributes);
        }
        String host = this.isNonArnOutpostRequest(context.request()) ? this.resolveHostForNonArnOutpostRequest(config, executionAttributes) : this.resolveHost(request, config);
        return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).host(host).build();
    }

    private String resolveHostForNonArnOutpostRequest(S3ControlConfiguration configuration, ExecutionAttributes executionAttributes) {
        if (Boolean.TRUE.equals(executionAttributes.getAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN))) {
            throw new IllegalArgumentException("Endpoint must not be overridden");
        }
        if (HandlerUtils.isDualstackEnabled(configuration)) {
            throw new IllegalArgumentException("Dualstack endpoints are not supported");
        }
        Region region = (Region)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION);
        if (HandlerUtils.isFipsEnabledInClientConfig(configuration) || HandlerUtils.isFipsRegion(region.id())) {
            throw new IllegalArgumentException("FIPS endpoints are not supported");
        }
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)"s3-outposts");
        String dnsSuffix = PartitionMetadata.of((Region)region).dnsSuffix();
        return String.format("s3-outposts.%s.%s", region, dnsSuffix);
    }

    private boolean isNonArnOutpostRequest(SdkRequest request) {
        if (request instanceof CreateBucketRequest && StringUtils.isNotBlank((CharSequence)((CreateBucketRequest)request).outpostId())) {
            return true;
        }
        return request instanceof ListRegionalBucketsRequest && StringUtils.isNotBlank((CharSequence)((ListRegionalBucketsRequest)request).outpostId());
    }

    private String resolveHost(SdkHttpRequest request, S3ControlConfiguration configuration) {
        if (HandlerUtils.isDualstackEnabled(configuration) && HandlerUtils.isFipsEnabledInClientConfig(configuration)) {
            throw SdkClientException.create((String)"Cannot use both Dual-Stack endpoints and FIPS endpoints");
        }
        String host = request.getUri().getHost();
        if (HandlerUtils.isDualstackEnabled(configuration)) {
            if (!host.contains("s3-control")) {
                throw SdkClientException.create((String)String.format("The Dual-Stack option cannot be used with custom endpoints (%s)", request.getUri()));
            }
            host = host.replace("s3-control", String.format("%s.%s", "s3-control", "dualstack"));
        } else if (HandlerUtils.isFipsEnabledInClientConfig(configuration)) {
            if (!host.contains("s3-control")) {
                throw SdkClientException.create((String)String.format("The FIPS option cannot be used with custom endpoints (%s)", request.getUri()));
            }
            host = host.replace("s3-control", String.format("%s-%s", "s3-control", "fips"));
        }
        return host;
    }
}

