/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.ServiceConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@Immutable
@ThreadSafe
public final class S3ControlConfiguration
implements ServiceConfiguration,
ToCopyableBuilder<Builder, S3ControlConfiguration> {
    private static final boolean DEFAULT_FIPS_MODE_ENABLED = false;
    private static final boolean DEFAULT_DUALSTACK_ENABLED = false;
    private final boolean fipsModeEnabled;
    private final boolean dualstackEnabled;

    private S3ControlConfiguration(DefaultS3ServiceConfigurationBuilder builder) {
        this.dualstackEnabled = this.resolveBoolean(builder.dualstackEnabled, false);
        this.fipsModeEnabled = this.resolveBoolean(builder.fipsModeEnabled, false);
    }

    public static Builder builder() {
        return new DefaultS3ServiceConfigurationBuilder();
    }

    public boolean fipsModeEnabled() {
        return this.fipsModeEnabled;
    }

    public boolean dualstackEnabled() {
        return this.dualstackEnabled;
    }

    private boolean resolveBoolean(Boolean suppliedValue, boolean defaultValue) {
        return suppliedValue == null ? defaultValue : suppliedValue;
    }

    public Builder toBuilder() {
        return S3ControlConfiguration.builder().dualstackEnabled(this.dualstackEnabled).fipsModeEnabled(this.fipsModeEnabled);
    }

    private static final class DefaultS3ServiceConfigurationBuilder
    implements Builder {
        private Boolean dualstackEnabled;
        private Boolean fipsModeEnabled;

        private DefaultS3ServiceConfigurationBuilder() {
        }

        @Override
        public Builder dualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled = dualstackEnabled;
            return this;
        }

        public void setDualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled(dualstackEnabled);
        }

        @Override
        public Builder fipsModeEnabled(Boolean fipsModeEnabled) {
            this.fipsModeEnabled = fipsModeEnabled;
            return this;
        }

        public void setFipsModeEnabled(Boolean fipsModeEnabled) {
            this.fipsModeEnabled(fipsModeEnabled);
        }

        public S3ControlConfiguration build() {
            return new S3ControlConfiguration(this);
        }
    }

    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, S3ControlConfiguration> {
        public Builder dualstackEnabled(Boolean var1);

        public Builder fipsModeEnabled(Boolean var1);
    }
}

