/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteObjectsRequest
extends S3Request
implements ToCopyableBuilder<Builder, DeleteObjectsRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteObjectsRequest.getter(DeleteObjectsRequest::bucket)).setter(DeleteObjectsRequest.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<Delete> DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeleteObjectsRequest.getter(DeleteObjectsRequest::delete)).setter(DeleteObjectsRequest.setter(Builder::delete)).constructor(Delete::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").unmarshallLocationName("Delete").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> MFA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteObjectsRequest.getter(DeleteObjectsRequest::mfa)).setter(DeleteObjectsRequest.setter(Builder::mfa)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-mfa").unmarshallLocationName("x-amz-mfa").build()}).build();
    private static final SdkField<String> REQUEST_PAYER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteObjectsRequest.getter(DeleteObjectsRequest::requestPayerAsString)).setter(DeleteObjectsRequest.setter(Builder::requestPayer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-request-payer").unmarshallLocationName("x-amz-request-payer").build()}).build();
    private static final SdkField<Boolean> BYPASS_GOVERNANCE_RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeleteObjectsRequest.getter(DeleteObjectsRequest::bypassGovernanceRetention)).setter(DeleteObjectsRequest.setter(Builder::bypassGovernanceRetention)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-bypass-governance-retention").unmarshallLocationName("x-amz-bypass-governance-retention").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, DELETE_FIELD, MFA_FIELD, REQUEST_PAYER_FIELD, BYPASS_GOVERNANCE_RETENTION_FIELD));
    private final String bucket;
    private final Delete delete;
    private final String mfa;
    private final String requestPayer;
    private final Boolean bypassGovernanceRetention;

    private DeleteObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.delete = builder.delete;
        this.mfa = builder.mfa;
        this.requestPayer = builder.requestPayer;
        this.bypassGovernanceRetention = builder.bypassGovernanceRetention;
    }

    public String bucket() {
        return this.bucket;
    }

    public Delete delete() {
        return this.delete;
    }

    public String mfa() {
        return this.mfa;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerAsString() {
        return this.requestPayer;
    }

    public Boolean bypassGovernanceRetention() {
        return this.bypassGovernanceRetention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.delete());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfa());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPayerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bypassGovernanceRetention());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectsRequest)) {
            return false;
        }
        DeleteObjectsRequest other = (DeleteObjectsRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.delete(), other.delete()) && Objects.equals(this.mfa(), other.mfa()) && Objects.equals(this.requestPayerAsString(), other.requestPayerAsString()) && Objects.equals(this.bypassGovernanceRetention(), other.bypassGovernanceRetention());
    }

    public String toString() {
        return ToString.builder((String)"DeleteObjectsRequest").add("Bucket", (Object)this.bucket()).add("Delete", (Object)this.delete()).add("MFA", (Object)this.mfa()).add("RequestPayer", (Object)this.requestPayerAsString()).add("BypassGovernanceRetention", (Object)this.bypassGovernanceRetention()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Delete": {
                return Optional.ofNullable(clazz.cast(this.delete()));
            }
            case "MFA": {
                return Optional.ofNullable(clazz.cast(this.mfa()));
            }
            case "RequestPayer": {
                return Optional.ofNullable(clazz.cast(this.requestPayerAsString()));
            }
            case "BypassGovernanceRetention": {
                return Optional.ofNullable(clazz.cast(this.bypassGovernanceRetention()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteObjectsRequest, T> g) {
        return obj -> g.apply((DeleteObjectsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private Delete delete;
        private String mfa;
        private String requestPayer;
        private Boolean bypassGovernanceRetention;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectsRequest model) {
            super(model);
            this.bucket(model.bucket);
            this.delete(model.delete);
            this.mfa(model.mfa);
            this.requestPayer(model.requestPayer);
            this.bypassGovernanceRetention(model.bypassGovernanceRetention);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final Delete.Builder getDelete() {
            return this.delete != null ? this.delete.toBuilder() : null;
        }

        @Override
        public final Builder delete(Delete delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(Delete.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        public final String getMfa() {
            return this.mfa;
        }

        @Override
        public final Builder mfa(String mfa) {
            this.mfa = mfa;
            return this;
        }

        public final void setMfa(String mfa) {
            this.mfa = mfa;
        }

        public final String getRequestPayerAsString() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final Boolean getBypassGovernanceRetention() {
            return this.bypassGovernanceRetention;
        }

        @Override
        public final Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
            return this;
        }

        public final void setBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteObjectsRequest build() {
            return new DeleteObjectsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteObjectsRequest> {
        public Builder bucket(String var1);

        public Builder delete(Delete var1);

        default public Builder delete(Consumer<Delete.Builder> delete) {
            return this.delete((Delete)((Delete.Builder)Delete.builder().applyMutation(delete)).build());
        }

        public Builder mfa(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder bypassGovernanceRetention(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

