/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBucketWebsiteRequest extends S3Request implements
        ToCopyableBuilder<PutBucketWebsiteRequest.Builder, PutBucketWebsiteRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutBucketWebsiteRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> CONTENT_MD5_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutBucketWebsiteRequest::contentMD5))
            .setter(setter(Builder::contentMD5))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-MD5")
                    .unmarshallLocationName("Content-MD5").build()).build();

    private static final SdkField<WebsiteConfiguration> WEBSITE_CONFIGURATION_FIELD = SdkField
            .<WebsiteConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutBucketWebsiteRequest::websiteConfiguration))
            .setter(setter(Builder::websiteConfiguration))
            .constructor(WebsiteConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteConfiguration")
                    .unmarshallLocationName("WebsiteConfiguration").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            CONTENT_MD5_FIELD, WEBSITE_CONFIGURATION_FIELD));

    private final String bucket;

    private final String contentMD5;

    private final WebsiteConfiguration websiteConfiguration;

    private PutBucketWebsiteRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.websiteConfiguration = builder.websiteConfiguration;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public WebsiteConfiguration websiteConfiguration() {
        return websiteConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(websiteConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketWebsiteRequest)) {
            return false;
        }
        PutBucketWebsiteRequest other = (PutBucketWebsiteRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(contentMD5(), other.contentMD5())
                && Objects.equals(websiteConfiguration(), other.websiteConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutBucketWebsiteRequest").add("Bucket", bucket()).add("ContentMD5", contentMD5())
                .add("WebsiteConfiguration", websiteConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "ContentMD5":
            return Optional.ofNullable(clazz.cast(contentMD5()));
        case "WebsiteConfiguration":
            return Optional.ofNullable(clazz.cast(websiteConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBucketWebsiteRequest, T> g) {
        return obj -> g.apply((PutBucketWebsiteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Request.Builder, SdkPojo, CopyableBuilder<Builder, PutBucketWebsiteRequest> {
        /**
         * <p/>
         * 
         * @param bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p/>
         * 
         * @param contentMD5
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * <p/>
         * 
         * @param websiteConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteConfiguration(WebsiteConfiguration websiteConfiguration);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link WebsiteConfiguration.Builder} avoiding the need
         * to create one manually via {@link WebsiteConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link WebsiteConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #websiteConfiguration(WebsiteConfiguration)}.
         * 
         * @param websiteConfiguration
         *        a consumer that will call methods on {@link WebsiteConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #websiteConfiguration(WebsiteConfiguration)
         */
        default Builder websiteConfiguration(Consumer<WebsiteConfiguration.Builder> websiteConfiguration) {
            return websiteConfiguration(WebsiteConfiguration.builder().applyMutation(websiteConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String contentMD5;

        private WebsiteConfiguration websiteConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketWebsiteRequest model) {
            super(model);
            bucket(model.bucket);
            contentMD5(model.contentMD5);
            websiteConfiguration(model.websiteConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final WebsiteConfiguration.Builder getWebsiteConfiguration() {
            return websiteConfiguration != null ? websiteConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder websiteConfiguration(WebsiteConfiguration websiteConfiguration) {
            this.websiteConfiguration = websiteConfiguration;
            return this;
        }

        public final void setWebsiteConfiguration(WebsiteConfiguration.BuilderImpl websiteConfiguration) {
            this.websiteConfiguration = websiteConfiguration != null ? websiteConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketWebsiteRequest build() {
            return new PutBucketWebsiteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
