/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p/>
 *
 * <h2>Code Examples</h2>
 * <p>
 * For code examples demonstrating how to use this service with the AWS SDK for Java v2, see:
 * </p>
 * <h3>Getting Started</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Hello_section.html" target="_top">Hello
 * Amazon S3</a></li>
 * </ul>
 * <h3>Basics</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_GettingStarted_section.html"
 * target="_top">Learn the basics of Amazon S3 with an AWS SDK</a></li>
 * </ul>
 * <h3>API Actions</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_CreateBucket_section.html"
 * target="_top">Use CreateBucket</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_UploadPartCopy_section.html"
 * target="_top">Use UploadPartCopy</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_CopyObject_section.html"
 * target="_top">Use CopyObject</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_GetBucketReplication_section.html"
 * target="_top">Use GetBucketReplication</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutBucketVersioning_section.html"
 * target="_top">Use PutBucketVersioning</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutBucketReplication_section.html"
 * target="_top">Use PutBucketReplication</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_DeleteBucketPolicy_section.html"
 * target="_top">Use DeleteBucketPolicy</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_DeleteObject_section.html"
 * target="_top">Use DeleteObject</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_DeleteObjects_section.html"
 * target="_top">Use DeleteObjects</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_DeleteBucketWebsite_section.html"
 * target="_top">Use DeleteBucketWebsite</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_GetBucketPolicy_section.html"
 * target="_top">Use GetBucketPolicy</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_HeadObject_section.html"
 * target="_top">Use HeadObject</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_GetObject_section.html"
 * target="_top">Use GetObject</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_GetObjectLegalHold_section.html"
 * target="_top">Use GetObjectLegalHold</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_GetObjectLockConfiguration_section.html"
 * target="_top">Use GetObjectLockConfiguration</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_GetObjectRetention_section.html"
 * target="_top">Use GetObjectRetention</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutBucketLifecycleConfiguration_section.html"
 * target="_top">Use PutBucketLifecycleConfiguration</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_AbortMultipartUpload_section.html"
 * target="_top">Use AbortMultipartUpload</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_ListMultipartUploads_section.html"
 * target="_top">Use ListMultipartUploads</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_ListObjectsV2_section.html"
 * target="_top">Use ListObjectsV2</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutObject_section.html"
 * target="_top">Use PutObject</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_RestoreObject_section.html"
 * target="_top">Use RestoreObject</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_DeleteBucket_section.html"
 * target="_top">Use DeleteBucket</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutBucketCors_section.html"
 * target="_top">Use PutBucketCors</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_GetBucketAcl_section.html"
 * target="_top">Use GetBucketAcl</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutBucketAcl_section.html"
 * target="_top">Use PutBucketAcl</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutBucketPolicy_section.html"
 * target="_top">Use PutBucketPolicy</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutBucketWebsite_section.html"
 * target="_top">Use PutBucketWebsite</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_ListBuckets_section.html"
 * target="_top">Use ListBuckets</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutObjectLegalHold_section.html"
 * target="_top">Use PutObjectLegalHold</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutObjectLockConfiguration_section.html"
 * target="_top">Use PutObjectLockConfiguration</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_PutObjectRetention_section.html"
 * target="_top">Use PutObjectRetention</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_SelectObjectContent_section.html"
 * target="_top">Use SelectObjectContent</a></li>
 * </ul>
 * <h3>Scenarios</h3>
 * <ul>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_sqs_Scenario_SqsExtendedClient_section.html"
 * target="_top">Manage large Amazon SQS messages using Amazon S3 with an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_cross_PAM_section.html"
 * target="_top">Create a photo asset management application that lets users manage photos using labels</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_cross_RekognitionPhotoAnalyzerPPE_section.html"
 * target="_top">Detect PPE in images with Amazon Rekognition using an AWS SDK</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_cross_RekognitionPhotoAnalyzer_section.html"
 * target="_top">Detect objects in images with Amazon Rekognition using an AWS SDK</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_cross_RekognitionVideoDetection_section.html"
 * target="_top">Detect people and objects in a video with Amazon Rekognition using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_PutBucketNotificationConfiguration_section.html"
 * target="_top">Send S3 event notifications to Amazon EventBridge using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_DownloadBucketToDirectory_section.html"
 * target="_top">Download all objects in an Amazon Simple Storage Service (Amazon S3) bucket to a local directory</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_UploadDirectoryToBucket_section.html"
 * target="_top">Recursively upload a local directory to an Amazon Simple Storage Service (Amazon S3) bucket</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_UsingLargeFiles_section.html"
 * target="_top">Upload or download large files to and from Amazon S3 using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_PresignedUrl_section.html"
 * target="_top">Create a presigned URL for Amazon S3 using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_URIParsing_section.html"
 * target="_top">Parse Amazon S3 URIs using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_UploadStream_section.html"
 * target="_top">Upload a stream of unknown size to an Amazon S3 object using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_UseChecksums_section.html"
 * target="_top">Use checksums to work with an Amazon S3 object using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_ObjectLock_section.html"
 * target="_top">Work with Amazon S3 object lock features using an AWS SDK</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_TrackUploadDownload_section.html"
 * target="_top">Track an Amazon S3 object upload or download using an AWS SDK</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_AbortMultipartUpload_section.html"
 * target="_top">Delete incomplete multipart uploads to Amazon S3 using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_ProcessS3EventNotification_section.html"
 * target="_top">Receive and process Amazon S3 event notifications by using an AWS SDK</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_DownloadS3Directory_section.html"
 * target="_top">Download S3 'directories' from an Amazon Simple Storage Service (Amazon S3) bucket</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_s3_Scenario_DoesBucketExist_section.html"
 * target="_top">Check if a bucket exists</a></li>
 * </ul>
 * <h3>Serverless Examples</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/s3_example_serverless_S3_Lambda_section.html"
 * target="_top">Invoke a Lambda function from an Amazon S3 trigger</a></li>
 * </ul>
 */
package software.amazon.awssdk.services.s3;