/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The updated server-side encryption type for this object. The <code>UpdateObjectEncryption</code> operation supports
 * the SSE-S3 and SSE-KMS encryption types.
 * </p>
 * <p>
 * Valid Values: <code>SSES3</code> | <code>SSEKMS</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectEncryption.Builder, ObjectEncryption> {
    private static final SdkField<SSEKMSEncryption> SSEKMS_FIELD = SdkField
            .<SSEKMSEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("SSEKMS")
            .getter(getter(ObjectEncryption::ssekms))
            .setter(setter(Builder::ssekms))
            .constructor(SSEKMSEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-KMS")
                    .unmarshallLocationName("SSE-KMS").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSEKMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SSEKMSEncryption ssekms;

    private final Type type;

    private ObjectEncryption(BuilderImpl builder) {
        this.ssekms = builder.ssekms;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies to update the object encryption type to server-side encryption with Key Management Service (KMS) keys
     * (SSE-KMS).
     * </p>
     * 
     * @return Specifies to update the object encryption type to server-side encryption with Key Management Service
     *         (KMS) keys (SSE-KMS).
     */
    public final SSEKMSEncryption ssekms() {
        return ssekms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ssekms());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectEncryption)) {
            return false;
        }
        ObjectEncryption other = (ObjectEncryption) obj;
        return Objects.equals(ssekms(), other.ssekms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectEncryption").add("SSEKMS", ssekms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SSEKMS":
            return Optional.ofNullable(clazz.cast(ssekms()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ssekms()} initialized to the given value.
     *
     * <p>
     * Specifies to update the object encryption type to server-side encryption with Key Management Service (KMS) keys
     * (SSE-KMS).
     * </p>
     * 
     * @param ssekms
     *        Specifies to update the object encryption type to server-side encryption with Key Management Service (KMS)
     *        keys (SSE-KMS).
     */
    public static ObjectEncryption fromSsekms(SSEKMSEncryption ssekms) {
        return builder().ssekms(ssekms).build();
    }

    /**
     * Create an instance of this class with {@link #ssekms()} initialized to the given value.
     *
     * <p>
     * Specifies to update the object encryption type to server-side encryption with Key Management Service (KMS) keys
     * (SSE-KMS).
     * </p>
     * 
     * @param ssekms
     *        Specifies to update the object encryption type to server-side encryption with Key Management Service (KMS)
     *        keys (SSE-KMS).
     */
    public static ObjectEncryption fromSsekms(Consumer<SSEKMSEncryption.Builder> ssekms) {
        SSEKMSEncryption.Builder builder = SSEKMSEncryption.builder();
        ssekms.accept(builder);
        return fromSsekms(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SSE-KMS", SSEKMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectEncryption, T> g) {
        return obj -> g.apply((ObjectEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectEncryption> {
        /**
         * <p>
         * Specifies to update the object encryption type to server-side encryption with Key Management Service (KMS)
         * keys (SSE-KMS).
         * </p>
         * 
         * @param ssekms
         *        Specifies to update the object encryption type to server-side encryption with Key Management Service
         *        (KMS) keys (SSE-KMS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssekms(SSEKMSEncryption ssekms);

        /**
         * <p>
         * Specifies to update the object encryption type to server-side encryption with Key Management Service (KMS)
         * keys (SSE-KMS).
         * </p>
         * This is a convenience method that creates an instance of the {@link SSEKMSEncryption.Builder} avoiding the
         * need to create one manually via {@link SSEKMSEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSEKMSEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #ssekms(SSEKMSEncryption)}.
         * 
         * @param ssekms
         *        a consumer that will call methods on {@link SSEKMSEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssekms(SSEKMSEncryption)
         */
        default Builder ssekms(Consumer<SSEKMSEncryption.Builder> ssekms) {
            return ssekms(SSEKMSEncryption.builder().applyMutation(ssekms).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SSEKMSEncryption ssekms;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectEncryption model) {
            ssekms(model.ssekms);
        }

        public final SSEKMSEncryption.Builder getSsekms() {
            return ssekms != null ? ssekms.toBuilder() : null;
        }

        public final void setSsekms(SSEKMSEncryption.BuilderImpl ssekms) {
            Object oldValue = this.ssekms;
            this.ssekms = ssekms != null ? ssekms.build() : null;
            handleUnionValueChange(Type.SSEKMS, oldValue, this.ssekms);
        }

        @Override
        public final Builder ssekms(SSEKMSEncryption ssekms) {
            Object oldValue = this.ssekms;
            this.ssekms = ssekms;
            handleUnionValueChange(Type.SSEKMS, oldValue, this.ssekms);
            return this;
        }

        @Override
        public ObjectEncryption build() {
            return new ObjectEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ObjectEncryption#type()
     */
    public enum Type {
        SSEKMS,

        UNKNOWN_TO_SDK_VERSION
    }
}
